/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.core;

import cn.xnatural.enet.common.Log;
import cn.xnatural.enet.core.AppContext;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyEngine {
    final Log log = Log.of(GroovyEngine.class);
    @Resource
    protected Executor exec;
    @Resource
    protected EP ep;
    @Resource
    protected AppContext ctx;
    protected Map bindAttr;
    protected GroovyScriptEngine gse;
    protected GroovyClassLoader gcl;

    public GroovyEngine() {
        this.log.setPrefixSupplier(() -> "[Groovy Engine]: ");
    }

    @EL(name={"sys.starting"}, async=false)
    protected void init() throws Exception {
        this.gcl = new GroovyClassLoader();
        this.bindAttr = new HashMap(5);
        this.bindAttr.put("log", this.log);
        this.bindAttr.put("ctx", this.ctx);
        this.bindAttr.put("env", this.ctx.env());
        this.bindAttr.put("ep", this.ep);
        this.bindAttr.put("exec", this.exec);
        String root_urls = this.ctx.env().getString("groovy.root-urls", "./script") + "/";
        this.gse = new GroovyScriptEngine(root_urls);
        this.log.info("inited. root-urls: {}", (Object)root_urls);
    }

    @EL(name={"groovy.eval"}, async=false)
    public Object eval(String scriptText, Consumer<Script> fn) {
        Script script = InvokerHelper.createScript((Class)this.gcl.parseClass(scriptText), (Binding)new Binding(new LinkedHashMap(this.bindAttr)));
        if (fn == null) {
            return script.run();
        }
        fn.accept(script);
        return null;
    }

    @EL(name={"groovy.script"}, async=false)
    public Object script(String scriptFile, Consumer<Script> fn) {
        Script script;
        try {
            script = InvokerHelper.createScript((Class)this.gse.loadScriptByName(scriptFile), (Binding)new Binding(new LinkedHashMap(this.bindAttr)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (fn == null) {
            return script.run();
        }
        fn.accept(script);
        return null;
    }
}

