/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.core;

import cn.xnatural.enet.common.Log;
import cn.xnatural.enet.common.Utils;
import cn.xnatural.enet.core.Environment;
import cn.xnatural.enet.core.GroovyEngine;
import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import cn.xnatural.enet.event.EP;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;

public class AppContext {
    protected Log log = Log.of(AppContext.class);
    protected String name;
    protected ThreadPoolExecutor exec;
    protected EP ep;
    protected Environment env;
    protected Map<String, Object> sourceMap = new HashMap<String, Object>();
    protected final Date startup = new Date();
    protected Thread shutdownHook = new Thread(() -> this.stop());
    protected Map<Class, Function<Map, Supplier>> aopFnCreator = new ConcurrentHashMap<Class, Function<Map, Supplier>>();

    public void start() {
        this.log.info("Starting Application on {} with PID {}", (Object)Utils.getHostname(), (Object)Utils.getPid());
        if (this.exec == null) {
            this.initExecutor();
        }
        this.ep = this.initEp();
        this.ep.addListenerSource((Object)this);
        this.sourceMap.forEach((k, v) -> {
            this.inject(v);
            this.ep.addListenerSource(v);
        });
        this.env = new Environment(this.ep);
        this.env.loadCfg();
        this.ep.fire("sys.starting", EC.of((Object)this).completeFn(ec -> {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            this.sourceMap.forEach((s, o) -> this.inject(o));
            this.log.info("Started Application" + (Utils.isBlank((CharSequence)this.getName()) ? "" : " '" + this.getName() + "' ") + "in {} seconds (JVM running for {})", (Object)((double)(System.currentTimeMillis() - this.startup.getTime()) / 1000.0), (Object)((double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0));
            this.ep.fire("sys.started", EC.of((Object)this));
        }));
    }

    public void stop() {
        this.ep.fire("sys.stopping", EC.of((Object)this).completeFn(ce -> {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            this.exec.shutdown();
        }));
    }

    @EL(name={"sys.addSource"}, async=false)
    public void addSource(Object source) {
        String name;
        Method m;
        if (source == null) {
            return;
        }
        if (source instanceof Class) {
            source = this.createObj((Class)source);
        }
        if ((m = Utils.findMethod(source.getClass(), mm -> Modifier.isPublic(mm.getModifiers()) && "getName".equals(mm.getName()) && mm.getParameterCount() == 0 && String.class.equals(mm.getReturnType()))) == null) {
            name = source.getClass().getSimpleName().replace("$$EnhancerByCGLIB$$", "@").split("@")[0];
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        } else {
            name = (String)Utils.invoke((Method)m, (Object)source, (Object[])new Object[0]);
        }
        if (Utils.isEmpty((String)name)) {
            this.log.warn("Get name property is empty from '{}'", source);
            return;
        }
        if ("sys".equalsIgnoreCase(name) || "env".equalsIgnoreCase(name) || "log".equalsIgnoreCase(name)) {
            this.log.warn("Name property cannot equal 'sys', 'env' or 'log' . source: {}", source);
            return;
        }
        if (this.sourceMap.containsKey(name)) {
            this.log.warn("Name property '{}' already exist in source: {}", (Object)name, this.sourceMap.get(name));
            return;
        }
        this.sourceMap.put(name, source);
        if (this.ep != null) {
            this.inject(source);
            this.ep.addListenerSource(source);
        }
    }

    @EL(name={"addAop"}, async=false)
    public void addAopFn(Class<? extends Annotation> anno, Function<Map, Supplier> fnCreator) {
        if (anno == null || fnCreator == null) {
            return;
        }
        this.log.debug("Add aop for annotation: '{}'", (Object)anno.getName());
        this.aopFnCreator.put(anno, fnCreator);
    }

    @EL(name={"createObj"}, async=false)
    protected Object createObj(Class clz) {
        Method m = Utils.findMethod((Class)clz, mm -> {
            Iterator<Class> it = this.aopFnCreator.keySet().iterator();
            while (it.hasNext()) {
                if (mm.getAnnotation(it.next()) == null) continue;
                return true;
            }
            return false;
        });
        if (m == null) {
            try {
                return clz.newInstance();
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
                return null;
            }
        }
        return Utils.proxy((Class)clz, (obj, method, args, proxy) -> {
            Supplier fn = () -> {
                try {
                    return proxy.invokeSuper(obj, args);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            };
            Annotation[] arr = method.getAnnotations();
            for (int i = arr.length - 1; i >= 0; --i) {
                Function<Map, Supplier> creator = this.aopFnCreator.get(arr[i].annotationType());
                if (creator == null) continue;
                HashMap<String, Object> attr = new HashMap<String, Object>(3);
                attr.put("method", method);
                attr.put("args", args);
                attr.put("fn", fn);
                fn = creator.apply(attr);
            }
            return fn.get();
        });
    }

    @EL(name={"inject"}, async=false)
    protected void inject(Object o) {
        Utils.iterateField(o.getClass(), (Consumer[])new Consumer[]{f -> {
            Resource r = f.getAnnotation(Resource.class);
            if (r == null) {
                return;
            }
            try {
                f.setAccessible(true);
                Object v = f.get(o);
                if (v != null) {
                    return;
                }
                v = EP.class.isAssignableFrom(f.getType()) ? this.wrapEpForSource(o) : (Executor.class.isAssignableFrom(f.getType()) ? this.wrapExecForSource(o) : (Environment.class.isAssignableFrom(f.getType()) ? this.env : (AppContext.class.isAssignableFrom(f.getType()) ? this : this.ep.fire("bean.get", EC.of((Object)this).sync().args(new Object[]{f.getType(), r.name()})))));
                if (v == null) {
                    return;
                }
                f.set(o, v);
                this.log.trace("Inject @Resource field '{}' for object '{}'", (Object)f.getName(), o);
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        }});
    }

    @EL(name={"bean.get", "sys.bean.get"}, async=false, order=1.0f)
    protected Object findLocalBean(EC ec, Class beanType, String beanName) {
        Object bean;
        block6: {
            block5: {
                if (ec.result != null) {
                    return ec.result;
                }
                bean = null;
                if (!Utils.isNotEmpty((String)beanName) || beanType == null) break block5;
                bean = this.sourceMap.get(beanName);
                if (bean == null || beanType.isAssignableFrom(bean.getClass())) break block6;
                bean = null;
                break block6;
            }
            if (Utils.isNotEmpty((String)beanName) && beanType == null) {
                bean = this.sourceMap.get(beanName);
            } else if (Utils.isEmpty((String)beanName) && beanType != null) {
                for (Map.Entry<String, Object> entry : this.sourceMap.entrySet()) {
                    if (!beanType.isAssignableFrom(entry.getValue().getClass())) continue;
                    bean = entry.getValue();
                    break;
                }
            }
        }
        return bean;
    }

    protected EP initEp() {
        return new EP(this.exec, (Logger)Log.of(EP.class)){

            protected Object doPublish(String eName, EC ec) {
                if (("sys.starting".equals(eName) || "sys.stopping".equals(eName) || "sys.started".equals(eName)) && ec.source() != AppContext.this) {
                    throw new UnsupportedOperationException("not allow fire event '" + eName + "'");
                }
                if ("env.updateAttr".equals(eName) && ec.source() != AppContext.this.env) {
                    throw new UnsupportedOperationException("not allow fire event '" + eName + "'");
                }
                return super.doPublish(eName, ec);
            }

            public String toString() {
                return "coreEp";
            }
        };
    }

    protected void initExecutor() {
        this.exec = new ThreadPoolExecutor(8, 8, 60L, TimeUnit.MINUTES, new LinkedBlockingQueue(), new ThreadFactory(){
            final AtomicInteger i = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "sys-" + this.i.getAndIncrement());
            }
        }){

            @Override
            public void execute(Runnable fn) {
                try {
                    super.execute(fn);
                }
                catch (RejectedExecutionException ex) {
                    AppContext.this.log.warn("Thread pool rejected new task very heavy load. {}", (Object)this);
                }
                catch (Throwable t) {
                    AppContext.this.log.error("Task happen unknown error", t);
                }
            }
        };
        this.exec.allowCoreThreadTimeOut(true);
    }

    @EL(name={"env.configured"}, async=false, order=-1.0f)
    protected void envConfigured() {
        Long k;
        Integer m;
        Integer c;
        String n = (String)this.env.getAttr("sys.name");
        if (Utils.isNotEmpty((String)n)) {
            this.name = n.trim();
        }
        if ((c = this.env.getInteger("sys.exec.corePoolSize", null)) != null) {
            if (c > this.exec.getMaximumPoolSize()) {
                this.exec.setMaximumPoolSize(c);
            }
            this.exec.setCorePoolSize(c);
        }
        if ((m = this.env.getInteger("sys.exec.maximumPoolSize", null)) != null && m > this.exec.getCorePoolSize()) {
            this.exec.setMaximumPoolSize(m);
        }
        if ((k = this.env.getLong("sys.exec.keepAliveTime", null)) != null) {
            this.exec.setKeepAliveTime(k, TimeUnit.SECONDS);
        }
        this.ep.addTrackEvent(this.env.getString("ep.track", "").split(","));
        if (this.env().getBoolean("groovy.enabled", false).booleanValue()) {
            this.addSource(new GroovyEngine());
        }
    }

    @EL(name={"env.updateAttr"})
    protected void updateAttr(String k, Object v) {
        if (k.startsWith("sys.exec.")) {
            if ("sys.exec.corePoolSize".equals(k)) {
                Integer i = Utils.toInteger((Object)v, null);
                if (i == null) {
                    throw new IllegalArgumentException("'sys.exec.corePoolSize' only can be int. " + v);
                }
                if (i > this.exec.getMaximumPoolSize()) {
                    this.exec.setMaximumPoolSize(i);
                }
                this.exec.setCorePoolSize(i);
            } else if ("sys.exec.maximumPoolSize".equals(k)) {
                Integer i = Utils.toInteger((Object)v, null);
                if (i == null) {
                    throw new IllegalArgumentException("'sys.exec.maximumPoolSize' only can be int. " + v);
                }
                if (i < this.exec.getCorePoolSize()) {
                    this.exec.setCorePoolSize(i);
                }
                this.exec.setMaximumPoolSize(i);
            } else if ("sys.exec.keepAliveTime".equals(k)) {
                Long l = Utils.toLong((Object)v, null);
                if (l == null) {
                    throw new IllegalArgumentException("'sys.exec.keepAliveTime' only can be int. " + v);
                }
                this.exec.setKeepAliveTime(l, TimeUnit.SECONDS);
            } else {
                this.log.warn("Not allow change property '{}'", (Object)k);
            }
        } else if (k.equals("ep.track")) {
            this.ep.addTrackEvent(this.env.getString("ep.track", "").split(","));
        }
    }

    @EL(name={"sys.info"})
    protected Object info() {
        HashMap<String, TreeSet<String>> info = new HashMap<String, TreeSet<String>>();
        info.put("modules", new TreeSet<String>(this.sourceMap.keySet()));
        return info;
    }

    protected Executor wrapExecForSource(Object source) {
        return new ExecutorService(){

            @Override
            public void shutdown() {
            }

            @Override
            public List<Runnable> shutdownNow() {
                return Collections.emptyList();
            }

            @Override
            public boolean isShutdown() {
                return AppContext.this.exec.isShutdown();
            }

            @Override
            public boolean isTerminated() {
                return AppContext.this.exec.isTerminated();
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return AppContext.this.exec.awaitTermination(timeout, unit);
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return AppContext.this.exec.submit(task);
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return AppContext.this.exec.submit(task, result);
            }

            @Override
            public Future<?> submit(Runnable task) {
                return AppContext.this.exec.submit(task);
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
                return AppContext.this.exec.invokeAll(tasks);
            }

            @Override
            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
                return AppContext.this.exec.invokeAll(tasks, timeout, unit);
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
                return AppContext.this.exec.invokeAny(tasks);
            }

            @Override
            public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return AppContext.this.exec.invokeAny(tasks, timeout, unit);
            }

            @Override
            public void execute(Runnable cmd) {
                AppContext.this.exec.execute(cmd);
            }

            public int getCorePoolSize() {
                return AppContext.this.exec.getCorePoolSize();
            }

            public int getWaitingCount() {
                return AppContext.this.exec.getQueue().size();
            }
        };
    }

    protected EP wrapEpForSource(final Object source) {
        return new EP(){

            protected void init(Executor exec, Logger log) {
            }

            public EP addTrackEvent(String ... eNames) {
                AppContext.this.ep.addTrackEvent(eNames);
                return this;
            }

            public EP delTrackEvent(String ... eNames) {
                AppContext.this.ep.delTrackEvent(eNames);
                return this;
            }

            public EP removeEvent(String eName, Object s) {
                if (source != null && s != null && source != s) {
                    throw new UnsupportedOperationException("Only allow remove event of this source: " + source);
                }
                AppContext.this.ep.removeEvent(eName, s);
                return this;
            }

            public EP addListenerSource(Object source2) {
                AppContext.this.ep.addListenerSource(source2);
                return this;
            }

            public boolean exist(String ... eNames) {
                return AppContext.this.ep.exist(eNames);
            }

            public Object fire(String eName, EC ec) {
                if (ec.source() == null) {
                    ec.source(source);
                }
                return AppContext.this.ep.fire(eName, ec);
            }

            public String toString() {
                return "wrappedCoreEp:" + source.getClass().getSimpleName();
            }
        };
    }

    public Environment env() {
        return this.env;
    }

    @EL(name={"sysName"}, async=false)
    public String getName() {
        return this.name;
    }

    public AppContext setName(String name) {
        if (this.exec != null) {
            throw new RuntimeException("Application is running, not allow change");
        }
        this.name = name;
        return this;
    }
}

