/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.event;

import cn.xnatural.enet.event.EC;
import cn.xnatural.enet.event.EL;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class EP {
    protected Logger log;
    protected Executor exec;
    protected Map<String, List<Listener>> lsMap;
    protected Set<String> trackEvents;
    protected Pattern p = Pattern.compile("\\{(?<attr>\\w+)\\}");

    public EP() {
        this.init(null, null);
    }

    public EP(Executor exec) {
        this.init(exec, null);
    }

    public EP(Executor exec, Logger log) {
        this.init(exec, log);
    }

    protected void init(Executor exec, Logger log) {
        this.exec = exec;
        this.log = log == null ? LoggerFactory.getLogger(EP.class) : log;
        this.lsMap = new ConcurrentHashMap<String, List<Listener>>();
        this.trackEvents = ConcurrentHashMap.newKeySet(7);
    }

    public Object fire(String eName) {
        return this.fire(eName, new EC());
    }

    public Object fire(String eName, Object ... args) {
        return this.fire(eName, new EC().args(args));
    }

    public Object fire(String eName, EC ec) {
        return this.doPublish(eName, ec);
    }

    protected Object doPublish(String eName, final EC ec) {
        List<Listener> ls;
        if (eName == null || eName.isEmpty()) {
            throw new IllegalArgumentException("eName is empty");
        }
        if (ec == null) {
            throw new NullPointerException("ec must not be null");
        }
        if (this.trackEvents.contains(eName) || this.log.isTraceEnabled()) {
            ec.track = true;
        }
        ls = new ArrayList((ls = this.lsMap.get(eName)) == null ? Collections.emptyList() : ls);
        ec.start(eName, ls, this);
        if (ec.isNoListener()) {
            ec.tryFinish();
            return ec.result;
        }
        if (this.exec == null) {
            for (Listener l2 : ls) {
                l2.invoke(ec);
            }
        } else {
            ArrayList<Listener> asyncLs = new ArrayList<Listener>(ls.size());
            ArrayList<Listener> syncLs = new ArrayList<Listener>(ls.size());
            if (ec.async == null) {
                for (Listener l3 : ls) {
                    if (l3.async) {
                        asyncLs.add(l3);
                        continue;
                    }
                    syncLs.add(l3);
                }
            } else if (ec.async.booleanValue()) {
                asyncLs.addAll(ls);
            } else {
                syncLs.addAll(ls);
            }
            syncLs.forEach(l -> l.invoke(ec));
            if (asyncLs.size() > 1) {
                final TreeMap<Float, Queue> orderGroupMap = new TreeMap<Float, Queue>();
                for (final Listener listener : asyncLs) {
                    final Queue groupLs = orderGroupMap.computeIfAbsent(Float.valueOf(listener.order), f -> new ConcurrentLinkedQueue());
                    groupLs.add(new Runnable(){

                        @Override
                        public void run() {
                            listener.invoke(ec);
                            groupLs.remove(this);
                            if (!groupLs.isEmpty()) {
                                return;
                            }
                            orderGroupMap.remove(Float.valueOf(listener.order));
                            Iterator it = orderGroupMap.entrySet().iterator();
                            if (it.hasNext()) {
                                ((Queue)it.next().getValue()).forEach(EP.this.exec::execute);
                            }
                        }
                    });
                }
                ((Queue)orderGroupMap.entrySet().iterator().next().getValue()).forEach(this.exec::execute);
            } else {
                asyncLs.forEach(l -> this.exec.execute(() -> l.invoke(ec)));
            }
        }
        return ec.result;
    }

    public boolean exist(String ... eNames) {
        if (eNames == null) {
            return false;
        }
        for (String n : eNames) {
            if (this.lsMap.containsKey(n)) continue;
            return false;
        }
        return true;
    }

    public EP addListenerSource(Object source) {
        this.resolve(source);
        return this;
    }

    public EP addTrackEvent(String ... eNames) {
        if (eNames == null) {
            return this;
        }
        for (String n : eNames) {
            if (n == null || n.trim().isEmpty()) continue;
            this.trackEvents.add(n.trim());
        }
        return this;
    }

    public EP delTrackEvent(String ... eNames) {
        if (eNames == null) {
            return this;
        }
        for (String n : eNames) {
            if (n == null || n.trim().isEmpty()) continue;
            this.trackEvents.remove(n);
        }
        return this;
    }

    public EP removeEvent(String eName, Object source) {
        this.log.debug("remove event '{}' with source: {}", (Object)eName, source);
        this.lsMap.get(eName).removeAll(this.lsMap.get(eName).stream().filter(o -> o.source == source).collect(Collectors.toSet()));
        return this;
    }

    public EP removeEvent(String eName) {
        this.lsMap.remove(eName);
        return this;
    }

    public EP removeSourceAllEvent(Object source) {
        Iterator<Map.Entry<String, List<Listener>>> it = this.lsMap.entrySet().iterator();
        while (it.hasNext()) {
            List<Listener> ls = it.next().getValue();
            ls.removeIf(l -> l.source == source);
            if (!ls.isEmpty()) continue;
            it.remove();
        }
        return this;
    }

    public EP listen(String eName, boolean async, float order, int limit, Runnable fn) {
        if (fn == null) {
            throw new NullPointerException("Param fn required");
        }
        List<Listener> ls = this.getListeners(eName);
        Listener l = new Listener();
        l.name = eName;
        l.fn = fn;
        l.async = async;
        l.order = order;
        l.limit(limit);
        ls.add(l);
        ls.sort(Comparator.comparing(o -> Float.valueOf(o.order)));
        return this;
    }

    public EP listen(String eName, boolean async, float order, int limit, Function fn) {
        if (fn == null) {
            throw new NullPointerException("fn must not be null");
        }
        List<Listener> ls = this.getListeners(eName);
        Listener l = new Listener();
        l.name = eName;
        l.fn1 = fn;
        l.async = async;
        l.order = order;
        l.limit(limit);
        ls.add(l);
        ls.sort(Comparator.comparing(o -> Float.valueOf(o.order)));
        return this;
    }

    public EP listen(String eName, boolean async, float order, int limit, BiFunction fn) {
        if (fn == null) {
            throw new NullPointerException("fn must not be null");
        }
        List<Listener> ls = this.getListeners(eName);
        Listener l = new Listener();
        l.name = eName;
        l.fn2 = fn;
        l.async = async;
        l.order = order;
        l.limit(limit);
        ls.add(l);
        ls.sort(Comparator.comparing(o -> Float.valueOf(o.order)));
        return this;
    }

    public EP listen(String eName, Runnable fn) {
        return this.listen(eName, false, 0.0f, 0, fn);
    }

    public EP listen(String eName, boolean async, Runnable fn) {
        return this.listen(eName, async, 0.0f, 0, fn);
    }

    public EP listen(String eName, Function fn) {
        return this.listen(eName, false, 0.0f, 0, fn);
    }

    public EP listen(String eName, boolean async, Function fn) {
        return this.listen(eName, async, 0.0f, 0, fn);
    }

    public EP listen(String eName, BiFunction fn) {
        return this.listen(eName, false, 0.0f, 0, fn);
    }

    public EP listen(String eName, boolean async, BiFunction fn) {
        return this.listen(eName, async, 0.0f, 0, fn);
    }

    protected void resolve(Object source) {
        if (source == null) {
            return;
        }
        this.iterateMethod(source.getClass(), m -> {
            EL el = m.getDeclaredAnnotation(EL.class);
            if (el == null) {
                return;
            }
            for (String n : el.name()) {
                Listener listener = new Listener();
                listener.async = el.async();
                listener.source = source;
                listener.order = el.order();
                listener.m = m;
                m.setAccessible(true);
                listener.name = this.parseName(n, source);
                listener.limit(el.limit());
                if (listener.name == null) continue;
                List<Listener> ls = this.getListeners(listener.name);
                if (ls.stream().anyMatch(l -> l.source == source && Objects.equals(l.m.getName(), listener.m.getName()))) {
                    this.log.warn("Same source same method name only one listener. source: {}, methodName: {}", source, (Object)m.getName());
                    continue;
                }
                this.log.debug("Add listener [name: {}, source: {}, method: {}, async: {}, order: {}]", new Object[]{listener.name, source, m.getName(), listener.async, Float.valueOf(listener.order)});
                ls.add(listener);
                ls.sort(Comparator.comparing(o -> Float.valueOf(o.order)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Listener> getListeners(String eName) {
        List<Listener> ls = this.lsMap.get(eName);
        if (ls == null) {
            EP eP = this;
            synchronized (eP) {
                ls = this.lsMap.get(eName);
                if (ls == null) {
                    ls = new CopyOnWriteArrayList<Listener>();
                    this.lsMap.put(eName, ls);
                }
            }
        }
        return ls;
    }

    protected String parseName(String name, Object source) {
        Matcher matcher = this.p.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        String attr = matcher.group("attr");
        Method m = this.findMethod(source.getClass(), mm -> Modifier.isPublic(mm.getModifiers()) && mm.getParameterCount() == 0 && String.class.equals(mm.getReturnType()) && ("get" + attr.substring(0, 1).toUpperCase() + attr.substring(1)).equals(mm.getName()));
        if (m != null) {
            try {
                Object v = m.invoke(source, new Object[0]);
                if (v == null || v.toString().isEmpty()) {
                    this.log.warn("Parse event name '{}' error. Get property '{}' is empty from '{}'.", new Object[]{name, attr, source});
                    return null;
                }
                return matcher.replaceAll(v.toString());
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        this.log.warn("Parse event name '{}'. Not found property '{}' from {} ", new Object[]{name, attr, source});
        return null;
    }

    protected void iterateMethod(Class clz, Consumer<Method> ... fns) {
        if (fns == null || fns.length < 1) {
            return;
        }
        Class c = clz;
        do {
            for (Method m : c.getDeclaredMethods()) {
                for (Consumer<Method> fn : fns) {
                    fn.accept(m);
                }
            }
        } while ((c = c.getSuperclass()) != null);
    }

    protected Method findMethod(Class clz, Predicate<Method> predicate) {
        Class c = clz;
        do {
            for (Method m : c.getDeclaredMethods()) {
                if (!predicate.test(m)) continue;
                return m;
            }
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    protected class Listener {
        protected Object source;
        Method m;
        protected Runnable fn;
        protected Function<Object, Object> fn1;
        protected BiFunction<Object, Object, Object> fn2;
        protected String name;
        protected float order;
        protected boolean async;
        protected int limit;
        protected AtomicInteger count;

        protected Listener() {
        }

        protected Listener limit(int limit) {
            if (limit > 0) {
                this.limit = limit;
                this.count = new AtomicInteger();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invoke(EC ec) {
            try {
                if (this.count != null && this.count.getAndIncrement() >= this.limit) {
                    return;
                }
                if (this.fn != null && ec.args == null) {
                    this.fn.run();
                } else if (this.fn1 != null) {
                    ec.result = this.fn1.apply(ec.args != null && ec.args.length > 0 ? ec.args[0] : null);
                } else if (this.fn2 != null) {
                    ec.result = this.fn2.apply(ec.args != null && ec.args.length > 0 ? ec.args[0] : null, ec.args != null && ec.args.length > 1 ? ec.args[1] : null);
                } else {
                    Object r = null;
                    if (this.m.getParameterCount() == 0) {
                        r = this.m.invoke(this.source, new Object[0]);
                    } else if (this.m.getParameterCount() == 1) {
                        Class<?> t = this.m.getParameterTypes()[0];
                        if (EC.class.isAssignableFrom(t)) {
                            r = this.m.invoke(this.source, ec);
                        } else if (t.isArray()) {
                            Object arr = Array.newInstance(t.getComponentType(), ec.args.length);
                            for (int i = 0; i < ec.args.length; ++i) {
                                Array.set(arr, i, t.getComponentType().cast(ec.args[i]));
                            }
                            r = this.m.invoke(this.source, arr);
                        } else {
                            Object arg = ec.args == null || ec.args.length < 1 ? null : ec.args[0];
                            r = this.m.invoke(this.source, arg);
                        }
                    } else {
                        Object[] args = new Object[this.m.getParameterCount()];
                        if (EC.class.isAssignableFrom(this.m.getParameterTypes()[0])) {
                            args[0] = ec;
                            if (ec.args != null) {
                                for (int i = 1; i <= ec.args.length && i < this.m.getParameterCount(); ++i) {
                                    args[i] = ec.args[i - 1];
                                }
                            }
                        } else if (ec.args != null) {
                            for (int i = 0; i < ec.args.length && i < this.m.getParameterCount(); ++i) {
                                args[i] = ec.args[i];
                            }
                        }
                        r = this.m.invoke(this.source, args);
                    }
                    if (!Void.TYPE.isAssignableFrom(this.m.getReturnType())) {
                        ec.result = r;
                    }
                }
                ec.passed(this, true);
                if (ec.track) {
                    EP.this.log.info("Passed listener of event '{}'. method: {}, id: {}, result: {}", new Object[]{this.name, this.m == null ? "" : this.source.getClass().getName() + "#" + this.m.getName(), ec.id, ec.result});
                }
            }
            catch (Throwable e) {
                ec.passed(this, false).ex(e.getCause() == null ? e : e.getCause());
                EP.this.log.error(MessageFormatter.arrayFormat((String)"Listener invoke error! eName: {}, id: {}, method: {}, event source: {}, args: {}", (Object[])new Object[]{this.name, ec.id, this.m == null ? "" : this.source.getClass().getName() + "#" + this.m.getName(), ec.source() == null ? "" : ec.source().getClass().getName(), Arrays.toString(ec.args)}).getMessage(), ec.ex);
            }
            finally {
                if (this.count != null && this.count.get() >= this.limit) {
                    List<Listener> ls = EP.this.lsMap.get(this.name);
                    if (ls == null) {
                        ec.willPass = null;
                    } else {
                        ls.remove(this);
                        if (ls.isEmpty()) {
                            EP.this.lsMap.remove(this.name);
                        }
                    }
                }
                ec.tryFinish();
            }
        }
    }
}

