/*
 * Decompiled with CFR 0.152.
 */
package cn.xnatural.enet.event;

import cn.xnatural.enet.event.EP;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class EC {
    protected String id;
    protected boolean track;
    protected Boolean async;
    Object[] args;
    EP ep;
    protected boolean pause;
    protected String eName;
    protected Consumer<EC> completeFn;
    private Object source;
    public Object result;
    protected Throwable ex;
    protected String errMsg;
    protected List<EP.Listener> willPass;
    protected final Queue<EP.Listener> successPassed = new ConcurrentLinkedQueue<EP.Listener>();
    protected final Queue<EP.Listener> failPassed = new ConcurrentLinkedQueue<EP.Listener>();
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    protected final Map<Object, Object> attrs = new ConcurrentHashMap<Object, Object>(7);

    public static EC of(Object source) {
        return new EC(source);
    }

    public static EC of(Object key, Object value) {
        return new EC().attr(key, value);
    }

    public EC() {
    }

    public EC(Object source) {
        this.source = source;
    }

    void start(String eName, List<EP.Listener> ls, EP ep) {
        this.eName = eName;
        this.willPass = ls;
        this.ep = ep;
        if (this.track) {
            this.id = UUID.randomUUID().toString().replaceAll("-", "");
            ep.log.info("Starting listener chain for event '{}'. id: {}, event source: {}", new Object[]{eName, this.id, this.source()});
        }
    }

    public void tryFinish() {
        if (this.stopped.get() || this.pause) {
            return;
        }
        boolean noL = this.isNoListener();
        if (noL && this.track) {
            this.ep.log.warn("Not found listener for event '{}'. id: {}", (Object)this.eName, (Object)this.id);
        }
        if ((noL || this.successPassed.size() + this.failPassed.size() == this.willPass.size()) && this.stopped.compareAndSet(false, true)) {
            boolean f = this.isSuccess();
            if (f && this.track) {
                this.ep.log.info("End listener chain for event '{}'. id: {}, result: {}", new Object[]{this.eName, this.id, this.result});
            } else if (!f) {
                this.ep.log.warn("End listener chain for event '{}'. id: {}, result: {}, failDesc: {}", new Object[]{this.eName, this.id, this.result, this.failDesc()});
            }
            Consumer<EC> fn = this.completeFn();
            if (fn != null) {
                fn.accept(this);
            }
        }
    }

    EC passed(EP.Listener l, boolean success) {
        if (success) {
            this.successPassed.add(l);
        } else {
            this.failPassed.add(l);
        }
        return this;
    }

    public boolean isSuccess() {
        return this.isNoListener() || this.willPass.size() == this.successPassed.size() && this.ex == null && this.errMsg == null && !this.pause;
    }

    public boolean isNoListener() {
        return this.willPass == null || this.willPass.isEmpty();
    }

    public EC completeFn(Consumer<EC> completeFn) {
        this.completeFn = completeFn;
        return this;
    }

    public Consumer<EC> completeFn() {
        return this.completeFn;
    }

    public EC suspend() {
        this.pause = true;
        return this;
    }

    public EC resume() {
        this.pause = false;
        return this;
    }

    public boolean isPause() {
        return this.pause;
    }

    public EC sync() {
        return this.async(false);
    }

    public EC async(Boolean async) {
        this.async = async;
        return this;
    }

    public Boolean isForceAsync() {
        return this.async;
    }

    public EC debug() {
        this.track = true;
        return this;
    }

    public boolean isTrack() {
        return this.track;
    }

    public EC args(Object ... args) {
        this.args = args;
        return this;
    }

    public EC id(String id) {
        this.id = id;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String eName() {
        return this.eName;
    }

    public EC ex(Throwable t) {
        this.ex = t;
        return this;
    }

    public Throwable ex() {
        return this.ex;
    }

    public EC errMsg(String msg) {
        this.errMsg = msg;
        return this;
    }

    public String errMsg() {
        return this.errMsg;
    }

    public String failDesc() {
        return this.ex() == null ? (this.errMsg() == null ? (this.pause ? "pausing" : "") : this.errMsg()) : (this.ex().getMessage() == null ? this.ex().getClass().getName() : this.ex().getMessage());
    }

    public Object source() {
        return this.source;
    }

    public EC source(Object s) {
        if (this.eName != null) {
            throw new RuntimeException("not allow change event source!");
        }
        this.source = s;
        return this;
    }

    public EC result(Object result) {
        this.result = result;
        return this;
    }

    public EP ep() {
        return this.ep;
    }

    public EC attr(Object key, Object value) {
        this.attrs.put(key, value);
        return this;
    }

    public <T> T getAttr(Object key, Class<T> type, T defaultValue) {
        if (this.attrs == null) {
            return defaultValue;
        }
        return type.cast(this.attrs.getOrDefault(key, defaultValue));
    }

    public <T> T getAttr(Object key, Class<T> type) {
        return this.getAttr(key, type, null);
    }

    public Object getAttr(Object key) {
        return this.attrs == null ? null : this.attrs.get(key);
    }
}

