/*
 * Decompiled with CFR 0.152.
 */
package cn.xlsea.influx.impl;

import cn.xlsea.influx.InfluxPlus;
import cn.xlsea.influx.annotation.TableField;
import cn.xlsea.influx.annotation.Tag;
import cn.xlsea.influx.property.InfluxProperty;
import cn.xlsea.influx.utils.ReflectUtils;
import jakarta.annotation.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.annotation.Measurement;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public class InfluxPlusImpl
implements InfluxPlus {
    private final Logger log = LoggerFactory.getLogger(InfluxPlus.class);
    @Resource
    private InfluxDB influxDB;
    @Resource
    private InfluxProperty influxProperty;

    @Override
    public Boolean ping() {
        boolean isConnected = false;
        try {
            Pong pong = this.influxDB.ping();
            if (pong != null) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isConnected;
    }

    @Override
    public Boolean exists() {
        String dataBaseName = this.influxProperty.getDataBaseName();
        return this.influxDB.databaseExists(dataBaseName);
    }

    @Override
    public Boolean exists(String dataBaseName) {
        return this.influxDB.databaseExists(dataBaseName);
    }

    @Override
    public String createDataBase() {
        String dataBaseName = this.influxProperty.getDataBaseName();
        this.influxDB.createDatabase(dataBaseName);
        this.log.debug("\u521b\u5efa\u6570\u636e\u5e93" + dataBaseName + "\u6210\u529f");
        return null;
    }

    @Override
    public String createDataBase(String dataBaseName) {
        this.influxDB.createDatabase(dataBaseName);
        this.log.debug("\u521b\u5efa\u6570\u636e\u5e93" + dataBaseName + "\u6210\u529f");
        return dataBaseName;
    }

    @Override
    public String deleteDataBase() {
        String dataBaseName = this.influxProperty.getDataBaseName();
        this.isExists(dataBaseName);
        this.influxDB.deleteDatabase(dataBaseName);
        this.log.debug("\u5220\u9664\u6570\u636e\u5e93 " + dataBaseName + " \u6210\u529f\uff01");
        return dataBaseName;
    }

    @Override
    public String deleteDataBase(String dataBaseName) {
        this.isExists(dataBaseName);
        this.influxDB.deleteDatabase(dataBaseName);
        this.log.debug("\u5220\u9664\u6570\u636e\u5e93 " + dataBaseName + " \u6210\u529f\uff01");
        return dataBaseName;
    }

    @Override
    public <T> int save(T object) {
        String dataBaseName = this.influxProperty.getDataBaseName();
        return this.save(object, dataBaseName, new String[0]);
    }

    @Override
    public <T> int save(T object, String dataBaseName, String ... arrays) {
        Object first;
        Class<?> clazz;
        boolean isAnnotation;
        this.isExists(dataBaseName);
        String tableStr = "";
        if (arrays.length != 0) {
            StringBuilder sb = new StringBuilder();
            for (String str : arrays) {
                sb.append(str);
            }
            tableStr = sb.toString();
        }
        if (!(isAnnotation = (clazz = (first = Lang.first(object)).getClass()).isAnnotationPresent(Measurement.class))) {
            throw new RuntimeException("\u63d2\u5165\u7684\u6570\u636e\u5bf9\u5e94\u5b9e\u4f53\u7c7b\u9700\u8981@Measurement\u6ce8\u89e3");
        }
        Measurement annotation = clazz.getAnnotation(Measurement.class);
        String measurement = annotation.name() + tableStr;
        Field[] arrField = clazz.getDeclaredFields();
        int size = Lang.eleSize(object);
        String tagField = ReflectUtils.getField(object, Tag.class);
        if (tagField == null) {
            throw new RuntimeException("\u63d2\u5165\u591a\u6761\u6570\u636e\u9700\u5bf9\u5e94\u5b9e\u4f53\u7c7b\u5b57\u6bb5\u6709@Tag\u6ce8\u89e3");
        }
        BatchPoints batchPoints = BatchPoints.database((String)dataBaseName).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            ++count;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Point.Builder builder = Point.measurement((String)measurement);
            for (Field field : arrField) {
                field.setAccessible(true);
                Object result = first;
                try {
                    if (size > 1) {
                        List objects = (List)object;
                        result = objects.get(i);
                    }
                    if (field.getName().equals(tagField)) {
                        String tagValue = ReflectUtils.getTagValue(object, field.getName());
                        if (tagValue != null && !tagValue.equals("")) {
                            builder.tag(tagValue, String.valueOf(field.get(result)));
                            continue;
                        }
                        builder.tag(tagField, String.valueOf(field.get(result)));
                        continue;
                    }
                    if (field.getName().equals("time")) {
                        Date date = (Date)field.get(result);
                        long time = date.getTime();
                        builder.time(time, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    boolean tableFieldExist = ReflectUtils.getTableFieldExist(object, field.getName());
                    if (!tableFieldExist) continue;
                    String aliasValue = ReflectUtils.getTableFieldValue(object, field.getName());
                    if (aliasValue != null && !aliasValue.equals("")) {
                        if (aliasValue.equals("time")) {
                            Date date = (Date)field.get(result);
                            long time = date.getTime();
                            builder.time(time, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        map.put(aliasValue, field.get(result));
                        continue;
                    }
                    map.put(field.getName(), field.get(result));
                }
                catch (IllegalAccessException e) {
                    this.log.error("\u5b9e\u4f53\u8f6c\u6362\u51fa\u9519");
                    e.printStackTrace();
                }
            }
            builder.fields(map);
            batchPoints.point(builder.build());
        }
        this.influxDB.write(batchPoints);
        return count;
    }

    @Override
    public <T> List<T> list(Class<T> clazz, String sql) {
        String dataBaseName = this.influxProperty.getDataBaseName();
        return this.list(clazz, sql, dataBaseName);
    }

    @Override
    public <T> List<T> list(Class<T> clazz, String sql, String dataBaseName) {
        this.isExists(dataBaseName);
        QueryResult results = this.influxDB.query(new Query(sql, dataBaseName), TimeUnit.MILLISECONDS);
        if (results != null) {
            if (results.getResults() == null) {
                return null;
            }
            ArrayList<T> list = new ArrayList<T>();
            for (QueryResult.Result result : results.getResults()) {
                List series = result.getSeries();
                if (series == null) continue;
                for (QueryResult.Series serie : series) {
                    List values = serie.getValues();
                    for (List value : values) {
                        Double time = (Double)value.get(0);
                        Date date = new Date(time.longValue());
                        value.set(0, date);
                    }
                    List columns = serie.getColumns();
                    list.addAll(this.getQueryData(clazz, columns, values));
                }
            }
            this.log.debug("sql -----> " + sql);
            return Json.fromJsonAsList(clazz, (CharSequence)Json.toJson(list));
        }
        return null;
    }

    @Override
    public <T> T getOne(Class<T> clazz, String sql) {
        String dataBaseName = this.influxProperty.getDataBaseName();
        return this.getOne(clazz, sql, dataBaseName);
    }

    @Override
    public <T> T getOne(Class<T> clazz, String sql, String dataBaseName) {
        List<T> list = this.list(clazz, sql, dataBaseName);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            this.log.warn("\u67e5\u8be2\u7ed3\u679c\u5927\u4e8e\u4e00\u6761");
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> int count(Class<T> clazz, String sql) {
        String dataBaseName = this.influxProperty.getDataBaseName();
        return this.count(clazz, sql, dataBaseName);
    }

    @Override
    public <T> int count(Class<T> clazz, String sql, String dataBaseName) {
        this.isExists(dataBaseName);
        QueryResult results = this.influxDB.query(new Query(sql, dataBaseName), TimeUnit.MILLISECONDS);
        if (results == null) {
            this.log.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u8bb0\u5f55");
            return 0;
        }
        if (results.hasError()) {
            throw new RuntimeException(results.getError());
        }
        try {
            Double double1 = (Double)((List)((QueryResult.Series)((QueryResult.Result)results.getResults().get(0)).getSeries().get(0)).getValues().get(0)).get(1);
            int count = double1.intValue();
            return count;
        }
        catch (Exception e) {
            this.log.error("\u8bf7\u68c0\u67e5\u60a8\u7684\u8bed\u53e5\u662f\u5426\u6b63\u786e");
            throw new RuntimeException("Not Found Records.");
        }
    }

    private void isExists(String dataBaseName) {
        if (dataBaseName == null) {
            throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u65f6\u914d\u7f6e\u6587\u4ef6 spring.influx.dataBaseName \u5fc5\u987b\u6307\u5b9a");
        }
        boolean exists = this.influxDB.databaseExists(dataBaseName);
        if (!exists) {
            throw new RuntimeException("\u6570\u636e\u5e93 " + dataBaseName + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6b64\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728");
        }
    }

    private <T> List<T> getQueryData(Class<T> clazz, List<String> columns, List<List<Object>> values) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (List<Object> list : values) {
            BeanWrapperImpl bean = null;
            Object result = null;
            try {
                result = clazz.newInstance();
                bean = new BeanWrapperImpl(result);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < list.size(); ++i) {
                String filedName = columns.get(i);
                if (filedName.equals("Tag")) continue;
                List<String> fields = ReflectUtils.getFields(result, TableField.class);
                for (String string : fields) {
                    String aliasValue = ReflectUtils.getTableFieldValue(result, string);
                    if (!filedName.equals(aliasValue)) continue;
                    filedName = string;
                }
                List<String> tags = ReflectUtils.getFields(result, Tag.class);
                for (String tag : tags) {
                    String tagValue = ReflectUtils.getTagValue(result, tag);
                    if (!filedName.equals(tagValue)) continue;
                    filedName = tag;
                }
                try {
                    clazz.getDeclaredField(filedName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                Object object = list.get(i);
                if (bean == null) continue;
                bean.setPropertyValue(filedName, object);
            }
            results.add(result);
        }
        return results;
    }
}

