/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.webservice.autoconfigure;

import cn.hutool.core.util.StrUtil;
import cn.xjbpm.ultron.common.util.ApplicationWebPathUtil;
import cn.xjbpm.ultron.common.util.BeanContextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jws.WebService;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Configuration
public class WebServiceCxfConfig {
    private static final Logger log = LoggerFactory.getLogger(WebServiceCxfConfig.class);
    private static final String WS_BASE_URL_PREFIX = "/webService/v1/";
    private final DefaultListableBeanFactory defaultListableBeanFactory;

    @Bean(name={"cxf"})
    public SpringBus springBus() {
        return new SpringBus();
    }

    @Bean(name={"cxfServlet"})
    public ServletRegistrationBean cxfServlet() {
        return new ServletRegistrationBean((Servlet)new CXFServlet(), new String[]{"/webService/v1/*"});
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerWebService() {
        String appRootPathUrl = ApplicationWebPathUtil.getAppRootPathUrl();
        List beansByAnnotation = BeanContextUtil.getBeansOfAnnotation(WebService.class);
        beansByAnnotation.forEach(webService -> {
            Class<?> webServiceClass = webService.getClass();
            Class webServiceImplClass = ClassUtils.getUserClass(webServiceClass);
            Class[] allInterfacesForClass = ClassUtils.getAllInterfacesForClass((Class)webServiceImplClass);
            List webServiceClassInterfaces = Arrays.stream(allInterfacesForClass).filter(i -> Objects.nonNull(i.getAnnotation(WebService.class))).collect(Collectors.toList());
            Assert.isTrue((webServiceClassInterfaces.size() == 1 ? 1 : 0) != 0, (String)("There should be only one WebService interface implemented  . by " + webServiceImplClass));
            Class webServiceInterfaceClass = (Class)webServiceClassInterfaces.get(0);
            WebService interfaceAnnotation = webServiceInterfaceClass.getAnnotation(WebService.class);
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)interfaceAnnotation.serviceName()), (String)("WebService serviceName can't be null. by " + webServiceInterfaceClass));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)interfaceAnnotation.targetNamespace()), (String)("WebService targetNamespace can't be null. by " + webServiceInterfaceClass));
            WebService implAnnotation = webServiceImplClass.getAnnotation(WebService.class);
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)implAnnotation.serviceName()), (String)("WebService serviceName can't be null. by " + webServiceImplClass));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)implAnnotation.targetNamespace()), (String)("WebService targetNamespace can't be null. by " + webServiceImplClass));
            EndpointImpl endpoint = new EndpointImpl((Bus)this.springBus(), webService);
            endpoint.publish(implAnnotation.serviceName());
            String beanName = implAnnotation.serviceName() + "Endpoint";
            this.defaultListableBeanFactory.registerSingleton(beanName, (Object)endpoint);
            log.info("\u6ce8\u518cwebservice\u670d\u52a1,\u7aef\u70b9:{},\u670d\u52a1\u5730\u5740\uff1a{}{}{}?wsdl", new Object[]{beanName, appRootPathUrl, WS_BASE_URL_PREFIX, implAnnotation.serviceName()});
        });
    }

    public WebServiceCxfConfig(DefaultListableBeanFactory defaultListableBeanFactory) {
        this.defaultListableBeanFactory = defaultListableBeanFactory;
    }
}

