/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.metrics;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mvc/api/v1/threadPool"})
public class ThreadPoolController {
    private List<Executor> executorList;

    @Lazy
    @Autowired
    public void setExecutorList(List<Executor> executorList) {
        this.executorList = executorList;
    }

    @GetMapping(value={"/list"})
    public List<Map<String, Object>> list() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.executorList.stream().filter(executor -> executor instanceof ThreadPoolTaskExecutor).forEach(executor -> {
            ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)executor;
            ThreadPoolExecutor poolExecutor = threadPoolTaskExecutor.getThreadPoolExecutor();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("ThreadNamePrefix\uff08\u7ebf\u7a0b\u540d\u524d\u7f00\uff09", threadPoolTaskExecutor.getThreadNamePrefix());
            map.put("CorePoolSize\uff08\u6838\u5fc3\u7ebf\u7a0b\u6570\uff09", poolExecutor.getCorePoolSize());
            map.put("MaxPoolSize\uff08\u6700\u5927\u7ebf\u7a0b\u6c60\u5927\u5c0f\uff09", threadPoolTaskExecutor.getMaxPoolSize());
            map.put("ActiveCount\uff08\u6b63\u5728\u6267\u884c\u4efb\u52a1\u7684\u7ebf\u7a0b\u6570\uff09", poolExecutor.getActiveCount());
            map.put("TaskCount\uff08\u8ba1\u5212\u6267\u884c\u7684\u4efb\u52a1\u603b\u6570\uff09", poolExecutor.getTaskCount());
            map.put("CompletedTaskCount\uff08\u5df2\u5b8c\u6210\u4efb\u52a1\u603b\u6570\uff09", poolExecutor.getCompletedTaskCount());
            map.put("MaximumPoolSize\uff08\u5141\u8bb8\u7684\u6700\u5927\u7ebf\u7a0b\u6570\uff09", poolExecutor.getMaximumPoolSize());
            map.put("LargestPoolSize\uff08\u5386\u53f2\u5cf0\u503c\u7ebf\u7a0b\u6570\uff09", poolExecutor.getLargestPoolSize());
            map.put("PoolSize\uff08\u5f53\u524d\u6c60\u4e2d\u7684\u7ebf\u7a0b\u6570\uff09", poolExecutor.getPoolSize());
            map.put("KeepAliveTime\uff08\u7a7a\u95f2\u65f6\u95f4\uff09", poolExecutor.getKeepAliveTime(TimeUnit.SECONDS));
            map.put("Queue.size\uff08\u5f53\u524d\u4efb\u52a1\u961f\u5217\u4e2d\u79ef\u538b\u4efb\u52a1\u7684\u603b\u6570\uff09", poolExecutor.getQueue().size());
            map.put("RemainingCapacity\uff08\u961f\u5217\u5927\u5c0f\uff09", poolExecutor.getQueue().remainingCapacity());
            list.add(map);
        });
        this.executorList.stream().filter(executor -> executor instanceof ThreadPoolTaskScheduler).forEach(executor -> {
            ThreadPoolTaskScheduler threadPoolTaskExecutor = (ThreadPoolTaskScheduler)executor;
            ScheduledThreadPoolExecutor poolExecutor = threadPoolTaskExecutor.getScheduledThreadPoolExecutor();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("ThreadNamePrefix\uff08\u7ebf\u7a0b\u540d\u524d\u7f00\uff09", threadPoolTaskExecutor.getThreadNamePrefix());
            map.put("CorePoolSize\uff08\u6838\u5fc3\u7ebf\u7a0b\u6570\uff09", poolExecutor.getCorePoolSize());
            map.put("ActiveCount\uff08\u6b63\u5728\u6267\u884c\u4efb\u52a1\u7684\u7ebf\u7a0b\u6570\uff09", poolExecutor.getActiveCount());
            map.put("TaskCount\uff08\u8ba1\u5212\u6267\u884c\u7684\u4efb\u52a1\u603b\u6570\uff09", poolExecutor.getTaskCount());
            map.put("CompletedTaskCount\uff08\u5df2\u5b8c\u6210\u4efb\u52a1\u603b\u6570\uff09", poolExecutor.getCompletedTaskCount());
            map.put("MaximumPoolSize\uff08\u5141\u8bb8\u7684\u6700\u5927\u7ebf\u7a0b\u6570\uff09", poolExecutor.getMaximumPoolSize());
            map.put("LargestPoolSize\uff08\u5386\u53f2\u5cf0\u503c\u7ebf\u7a0b\u6570\uff09", poolExecutor.getLargestPoolSize());
            map.put("PoolSize\uff08\u5f53\u524d\u6c60\u4e2d\u7684\u7ebf\u7a0b\u6570\uff09", poolExecutor.getPoolSize());
            map.put("KeepAliveTime\uff08\u7a7a\u95f2\u65f6\u95f4\uff09", poolExecutor.getKeepAliveTime(TimeUnit.SECONDS));
            map.put("Queue.size\uff08\u5f53\u524d\u4efb\u52a1\u961f\u5217\u4e2d\u79ef\u538b\u4efb\u52a1\u7684\u603b\u6570\uff09", poolExecutor.getQueue().size());
            map.put("RemainingCapacity\uff08\u961f\u5217\u5927\u5c0f\uff09", poolExecutor.getQueue().remainingCapacity());
            list.add(map);
        });
        return list;
    }
}

