/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.interceptor;

import cn.hutool.core.util.StrUtil;
import cn.xjbpm.ultron.common.util.LoginUserUtil;
import cn.xjbpm.ultron.web.constant.LogConstants;
import cn.xjbpm.ultron.web.trace.TraceManager;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TraceHandlerInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String traceId = request.getHeader(LogConstants.TRACE_ID);
        MDC.put((String)LogConstants.TRACE_ID, (String)(StrUtil.isNotEmpty((CharSequence)traceId) ? traceId : TraceManager.createTraceId()));
        String traceUser = request.getHeader(LogConstants.TRACE_USER);
        if (StrUtil.isNotEmpty((CharSequence)traceUser)) {
            MDC.put((String)LogConstants.TRACE_USER, (String)traceUser);
        } else {
            Optional optionalOperator = LoginUserUtil.getOptionalOperator();
            optionalOperator.ifPresent(operatorUserVO -> MDC.put((String)LogConstants.TRACE_USER, (String)operatorUserVO.getUserName()));
        }
        response.addHeader(LogConstants.TRACE_ID, MDC.get((String)LogConstants.TRACE_ID));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        MDC.remove((String)LogConstants.TRACE_ID);
        MDC.remove((String)LogConstants.TRACE_USER);
    }
}

