/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.xjbpm.ultron.common.util.RequestContextUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.springframework.util.StreamUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;
    private Map<String, String[]> parameterMap;

    public XssHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.parameterMap = request.getParameterMap();
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (Objects.nonNull(values)) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = HtmlUtil.cleanHtmlTag((String)values[i]).trim();
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public boolean hasBody() {
        return this.body.length > 0;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (RequestContextUtil.isJsonRequest()) {
            String json = IOUtils.toString((byte[])this.body, (String)"UTF-8");
            if (StrUtil.isEmpty((CharSequence)json)) {
                return new RequestCatchingServletInputStream(new ByteArrayInputStream(this.body));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(HtmlUtil.cleanHtmlTag((String)json).trim().getBytes(StandardCharsets.UTF_8));
            return new RequestCatchingServletInputStream(bais);
        }
        return new RequestCatchingServletInputStream(new ByteArrayInputStream(this.body));
    }

    static class RequestCatchingServletInputStream
    extends ServletInputStream {
        ByteArrayInputStream bais;

        public RequestCatchingServletInputStream(ByteArrayInputStream bais) {
            this.bais = bais;
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() {
            return this.bais.read();
        }
    }
}

