/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.filter;

import cn.xjbpm.ultron.web.filter.XssHttpServletRequestWrapper;
import cn.xjbpm.ultron.web.properties.UltronMvcProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;

public class XssHttpServletRequestFilter
implements Filter {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private final UltronMvcProperties.Xss xssProperties;

    public XssHttpServletRequestFilter(UltronMvcProperties xssProperties) {
        this.xssProperties = xssProperties.getXss();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.handleExcludeURL(req) || RequestMethod.OPTIONS.name().equals(((HttpServletRequest)request).getMethod())) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request), response);
        }
    }

    private boolean handleExcludeURL(HttpServletRequest request) {
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        String requestUri = request.getRequestURI();
        for (String exclude : this.xssProperties.getExcludes()) {
            if (!ANT_PATH_MATCHER.match(exclude, requestUri)) continue;
            return true;
        }
        return false;
    }
}

