/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.event;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.xjbpm.ultron.common.event.AutoMenuAuthDTO;
import cn.xjbpm.ultron.common.event.AutoRegisterMenuEvent;
import cn.xjbpm.ultron.common.util.BeanContextUtil;
import cn.xjbpm.ultron.common.util.JsonUtil;
import cn.xjbpm.ultron.common.util.spel.SpELUtil;
import cn.xjbpm.ultron.web.annotation.GenerateMenu;
import cn.xjbpm.ultron.web.annotation.GenerateMenuGroup;
import cn.xjbpm.ultron.web.annotation.SecurityPermissions;
import cn.xjbpm.ultron.web.util.GenerateMenuUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
@Component
public class AutoRegisterMenuAuthApplicationReadyEvent {
    private static final Logger log = LoggerFactory.getLogger(AutoRegisterMenuAuthApplicationReadyEvent.class);
    private static volatile HashMap<String, AutoMenuAuthDTO> hashMap = MapUtil.newHashMap();
    private static volatile Set<Class> hashSet = new HashSet<Class>();
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        BeanContextUtil.publishAsyncEvent((Object)new AutoRegisterMenuEvent((Object)this, this.scanRequestMapping()));
    }

    public List<AutoMenuAuthDTO> scanRequestMapping() {
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry requestMappingInfoHandlerMethodEntry : handlerMethods.entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue();
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey();
            Set patterns = requestMappingInfo.getPatternsCondition().getPatterns();
            Object[] objects = patterns.toArray();
            if (objects.length <= 0) continue;
            String path = String.valueOf(objects[0]);
            GenerateMenuGroup generateMenuGroup = handlerMethod.getBeanType().getAnnotation(GenerateMenuGroup.class);
            Map<String, Object> context = GenerateMenuUtil.buildContext(generateMenuGroup);
            this.pushGroupMenus(generateMenuGroup, context, handlerMethod.getBeanType());
            GenerateMenu methodGenerateMenu = handlerMethod.getMethod().getAnnotation(GenerateMenu.class);
            SecurityPermissions securityPermissions = handlerMethod.getMethod().getAnnotation(SecurityPermissions.class);
            if (!Objects.nonNull(methodGenerateMenu)) continue;
            AutoMenuAuthDTO menuVO2 = this.buildAutoMenuAuth(methodGenerateMenu, securityPermissions, context);
            menuVO2.setRequestMappingPath(path);
            Assert.hasText((String)menuVO2.getCustomizeId(), (String)String.format("\u83dc\u5355 CustomizeId \u4e0d\u80fd\u4e3a\u7a7a\uff1a%s", handlerMethod.getShortLogMessage()));
            Assert.hasText((String)menuVO2.getName(), (String)String.format("\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1a%s", handlerMethod.getShortLogMessage()));
            Assert.isTrue((!hashMap.containsKey(menuVO2.getCustomizeId()) ? 1 : 0) != 0, (String)String.format("[%s]\u83dc\u5355\u81ea\u5b9a\u4e49ID\u4e0d\u80fd\u51fa\u73b0\u91cd\u590d\uff1a%s %s", menuVO2.getName(), menuVO2.getCustomizeId(), handlerMethod.getShortLogMessage()));
            hashMap.put(menuVO2.getCustomizeId(), menuVO2);
        }
        ArrayList<AutoMenuAuthDTO> menus = new ArrayList<AutoMenuAuthDTO>();
        hashMap.forEach((s, menuVO) -> menus.add((AutoMenuAuthDTO)menuVO));
        return menus;
    }

    private synchronized void pushGroupMenus(GenerateMenuGroup annotation, Map<String, Object> context, Class<?> beanClass) {
        if (!hashSet.contains(beanClass) && Objects.nonNull(annotation)) {
            GenerateMenu[] menus;
            hashSet.add(beanClass);
            for (GenerateMenu menu : menus = annotation.menus()) {
                AutoMenuAuthDTO menuVO = this.buildAutoMenuAuth(menu, null, context);
                menuVO.setRequestMappingPath(this.getClassRequestMappingPath(beanClass));
                Assert.hasText((String)menuVO.getCustomizeId(), (String)String.format("\u7c7b\u4e0a\u7ed1\u5b9a\u7684\u83dc\u5355 -> CustomizeId \u4e0d\u80fd\u4e3a\u7a7a\uff1a%s", beanClass));
                Assert.hasText((String)menuVO.getName(), (String)String.format("\u7c7b\u4e0a\u7ed1\u5b9a\u7684\u83dc\u5355 -> \u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1a%s", beanClass));
                Assert.isTrue((!hashMap.containsKey(menuVO.getCustomizeId()) ? 1 : 0) != 0, (String)String.format("[%s]\u83dc\u5355\u81ea\u5b9a\u4e49ID\u4e0d\u80fd\u51fa\u73b0\u91cd\u590d\uff1a%s %s", menuVO.getName(), menuVO.getCustomizeId(), beanClass));
                hashMap.put(menuVO.getCustomizeId(), menuVO);
            }
        }
    }

    private AutoMenuAuthDTO buildAutoMenuAuth(GenerateMenu methodGenerateMenu, SecurityPermissions securityPermissions, Map<String, Object> context) {
        AutoMenuAuthDTO menuVO = new AutoMenuAuthDTO();
        menuVO.setName(this.getMenuName(methodGenerateMenu, context));
        menuVO.setCustomizeId(this.getCustomizeId(methodGenerateMenu, context));
        menuVO.setParentCustomizeId(this.getParentCustomizeId(methodGenerateMenu, context));
        menuVO.setPermissions(this.getPermissions(methodGenerateMenu, securityPermissions, context));
        menuVO.setType(methodGenerateMenu.type());
        menuVO.setIcon(methodGenerateMenu.icon());
        return menuVO;
    }

    private String getCustomizeId(GenerateMenu methodGenerateMenu, Map<String, Object> context) {
        String expression = StrUtil.isNotBlank((CharSequence)methodGenerateMenu.customizeId()) ? methodGenerateMenu.customizeId() : "";
        String value = SpELUtil.parseValueToString(context, (String)expression);
        if (log.isTraceEnabled()) {
            log.trace("\u83b7\u53d6\u83dc\u5355\u552f\u4e00ID -> \u8868\u8fbe\u5f0f:'{}' \u8ba1\u7b97\u540e\uff1a'{}' \u4e0a\u4e0b\u6587:'{}'", new Object[]{expression, value, JsonUtil.obj2Json(context)});
        }
        return value;
    }

    private String getParentCustomizeId(GenerateMenu methodGenerateMenu, Map<String, Object> context) {
        String expression = StrUtil.isNotBlank((CharSequence)methodGenerateMenu.parentCustomizeId()) ? methodGenerateMenu.parentCustomizeId() : "";
        String value = SpELUtil.parseValueToString(context, (String)expression);
        if (log.isTraceEnabled()) {
            log.trace("\u83b7\u53d6\u83dc\u5355\u552f\u4e00ID -> \u8868\u8fbe\u5f0f:'{}' \u8ba1\u7b97\u540e\uff1a'{}' \u4e0a\u4e0b\u6587:'{}'", new Object[]{expression, value, JsonUtil.obj2Json(context)});
        }
        return value;
    }

    private String getPermissions(GenerateMenu methodGenerateMenu, SecurityPermissions securityPermissions, Map<String, Object> context) {
        String expression;
        String string = expression = StrUtil.isNotBlank((CharSequence)methodGenerateMenu.permissions()) ? methodGenerateMenu.permissions() : "";
        if (StrUtil.isBlank((CharSequence)expression) && Objects.nonNull(securityPermissions)) {
            expression = StrUtil.isNotBlank((CharSequence)securityPermissions.value()[0]) ? securityPermissions.value()[0] : "";
        }
        String value = SpELUtil.parseValueToString(context, (String)expression);
        if (log.isTraceEnabled()) {
            log.trace("\u83b7\u53d6\u6743\u9650\u5b57\u7b26\u4e32 -> \u8868\u8fbe\u5f0f:'{}' \u8ba1\u7b97\u540e\uff1a'{}' \u4e0a\u4e0b\u6587:'{}'", new Object[]{expression, value, JsonUtil.obj2Json(context)});
        }
        return value;
    }

    private String getMenuName(GenerateMenu methodGenerateMenu, Map<String, Object> context) {
        String expression = StrUtil.isNotBlank((CharSequence)methodGenerateMenu.name()) ? methodGenerateMenu.name() : "";
        String value = SpELUtil.parseValueToString(context, (String)expression);
        if (log.isTraceEnabled()) {
            log.trace("\u83b7\u53d6\u83dc\u5355\u540d\u79f0 -> \u8868\u8fbe\u5f0f:'{}' \u8ba1\u7b97\u540e\uff1a'{}' \u4e0a\u4e0b\u6587:'{}'", new Object[]{expression, value, JsonUtil.obj2Json(context)});
        }
        return value;
    }

    private String getClassRequestMappingPath(Class<?> klass) {
        RequestMapping requestMapping = klass.getAnnotation(RequestMapping.class);
        if (Objects.nonNull(requestMapping)) {
            String[] value = requestMapping.value();
            String[] path = requestMapping.path();
            if (Objects.isNull(value) && Objects.nonNull(path)) {
                value = path;
            }
            return value[0];
        }
        return StrUtil.lowerFirst((CharSequence)klass.getName());
    }

    public AutoRegisterMenuAuthApplicationReadyEvent(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }
}

