/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.controller;

import cn.xjbpm.ultron.common.enums.MenuType;
import cn.xjbpm.ultron.common.vo.BaseVO;
import cn.xjbpm.ultron.common.vo.PageReqVO;
import cn.xjbpm.ultron.common.vo.PageRespVO;
import cn.xjbpm.ultron.web.annotation.GenerateMenu;
import cn.xjbpm.ultron.web.annotation.NoRepeatSubmit;
import cn.xjbpm.ultron.web.annotation.SecurityPermissions;
import cn.xjbpm.ultron.web.service.CommonService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class CommonController<Service extends CommonService<ID, VO, PageVO>, ID extends Serializable, VO extends BaseVO, PageVO extends PageReqVO> {
    @Autowired
    protected Service service;

    @ApiOperation(value="\u4fdd\u5b58\u5bf9\u8c61")
    @PostMapping(value={"/save"})
    @GenerateMenu(name="\u4fdd\u5b58\u5bf9\u8c61", type=MenuType.RESOURCE, customizeId="#{args[0]}_save", parentCustomizeId="#{args[0]}_manage")
    @SecurityPermissions(value={"#{args[0]}_save"})
    @NoRepeatSubmit
    @CacheEvict(key="#vo.id", condition="#vo.id != null", cacheResolver="commonCacheResolver")
    public boolean save(@RequestBody VO vo) {
        return this.service.save(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5bf9\u8c61\u4fe1\u606f")
    @PostMapping(value={"/get"})
    @GenerateMenu(name="\u83b7\u53d6\u5bf9\u8c61\u4fe1\u606f", type=MenuType.RESOURCE, customizeId="#{args[0]}_get", parentCustomizeId="#{args[0]}_manage")
    @SecurityPermissions(value={"#{args[0]}_get"})
    @Cacheable(key="#id", cacheResolver="commonCacheResolver")
    public VO get(@NotNull(message="\u4e3b\u952eID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @RequestParam @NotNull(message="\u4e3b\u952eID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") ID id) {
        return this.service.findById(id);
    }

    @ApiOperation(value="\u5220\u9664\u5bf9\u8c61\u4fe1\u606f")
    @PostMapping(value={"/deleteById"})
    @GenerateMenu(name="\u5220\u9664\u5bf9\u8c61\u4fe1\u606f", type=MenuType.RESOURCE, customizeId="#{args[0]}_delete", parentCustomizeId="#{args[0]}_manage")
    @SecurityPermissions(value={"#{args[0]}_delete"})
    @CacheEvict(key="#id", cacheResolver="commonCacheResolver")
    public boolean deleteById(@NotNull(message="\u4e3b\u952eID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @RequestParam @NotNull(message="\u4e3b\u952eID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") ID id) {
        return this.service.deleteById(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bf9\u8c61\u4fe1\u606f")
    @PostMapping(value={"/listByPageQuery"})
    @GenerateMenu(name="\u5206\u9875\u67e5\u8be2\u5bf9\u8c61\u4fe1\u606f", type=MenuType.RESOURCE, customizeId="#{args[0]}_list_by_page_query", parentCustomizeId="#{args[0]}_manage")
    @SecurityPermissions(value={"#{args[0]}_list_by_page_query"})
    public PageRespVO<Iterable<VO>> listByPageQuery(@RequestBody PageVO pageVO) {
        return this.service.listByPageQuery(pageVO);
    }
}

