/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.autoconfigure;

import cn.xjbpm.ultron.web.filter.RequestRepeatableWrapperFilter;
import cn.xjbpm.ultron.web.filter.XssHttpServletRequestFilter;
import cn.xjbpm.ultron.web.interceptor.TraceHandlerInterceptor;
import cn.xjbpm.ultron.web.properties.UltronMvcProperties;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcAutoConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcAutoConfig.class);
    private final TraceHandlerInterceptor traceHandlerInterceptor;
    private final UltronMvcProperties ultronMvcProperties;
    @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
    private String defaultDatePattern;
    @Value(value="${spring.jackson.time-zone:GMT+8}")
    private String defaultTimeZone;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.traceHandlerInterceptor).addPathPatterns(new String[]{"/**"}).order(0);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern(this.defaultDatePattern);
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        return builder -> {
            builder.locale(Locale.CHINA);
            builder.failOnEmptyBeans(false);
            builder.failOnUnknownProperties(false);
            builder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
            builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
            builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
            builder.timeZone(this.defaultTimeZone);
            builder.simpleDateFormat(this.defaultDatePattern);
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATETIME_FORMATTER));
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DATETIME_FORMATTER));
            builder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
            builder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
        };
    }

    public void addFormatters(FormatterRegistry registry) {
        DateTimeFormatterRegistrar registrar = new DateTimeFormatterRegistrar();
        registrar.setUseIsoFormat(true);
        registrar.registerFormatters(registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.setCorsConfigurations(this.ultronMvcProperties.getCorsConfigurations());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public FilterRegistrationBean requestRepeatableFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RequestRepeatableWrapperFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(100);
        return registration;
    }

    @Bean
    public FilterRegistrationBean xssHttpServletRequestFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssHttpServletRequestFilter(this.ultronMvcProperties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(99);
        return registration;
    }

    public WebMvcAutoConfig(TraceHandlerInterceptor traceHandlerInterceptor, UltronMvcProperties ultronMvcProperties) {
        this.traceHandlerInterceptor = traceHandlerInterceptor;
        this.ultronMvcProperties = ultronMvcProperties;
    }
}

