/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.autoconfigure;

import cn.hutool.core.collection.CollUtil;
import cn.xjbpm.ultron.web.properties.UltronMvcProperties;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@EnableOpenApi
public class SwaggerConfig {
    private final UltronMvcProperties ultronMvcProperties;
    @Value(value="${spring.application.name:Ultron}")
    private String applicationName;

    @Bean
    public Docket initDocket(Environment env) {
        UltronMvcProperties.Swagger swagger = this.ultronMvcProperties.getSwagger();
        Profiles profile = CollUtil.isEmpty(swagger.getProfiles()) ? Profiles.of((String[])new String[]{"dev"}) : Profiles.of((String[])swagger.getProfiles().toArray(new String[0]));
        boolean flag = env.acceptsProfiles(profile);
        return new Docket(DocumentationType.OAS_30).apiInfo(this.apiInfo()).enable(flag).select().apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).paths(PathSelectors.any()).build().globalRequestParameters(this.getGlobalRequestParameters());
    }

    private List<RequestParameter> getGlobalRequestParameters() {
        ArrayList<RequestParameter> parameters = new ArrayList<RequestParameter>();
        parameters.add(new RequestParameterBuilder().name("authorization").description("jwt\u6388\u6743token").in(ParameterType.HEADER).query(q -> q.model(m -> m.scalarModel(ScalarType.STRING))).required(Boolean.valueOf(false)).build());
        return parameters;
    }

    private ApiInfo apiInfo() {
        UltronMvcProperties.Swagger swagger = this.ultronMvcProperties.getSwagger();
        return new ApiInfoBuilder().title(Optional.ofNullable(swagger.getTitle()).orElse(this.applicationName + "  Swagger3-\u63a5\u53e3\u6587\u6863")).description(swagger.getDescription()).contact(new Contact(swagger.getContactName(), swagger.getContactUrl(), swagger.getContactEmail())).version(swagger.getVersion()).build();
    }

    public SwaggerConfig(UltronMvcProperties ultronMvcProperties) {
        this.ultronMvcProperties = ultronMvcProperties;
    }
}

