/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.xjbpm.ultron.common.exception.BusinessSilenceException;
import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.exception.HttpStatusExceptionEnum;
import cn.xjbpm.ultron.common.util.LoginUserUtil;
import cn.xjbpm.ultron.common.util.spel.SpELUtil;
import cn.xjbpm.ultron.common.vo.OperatorUserVO;
import cn.xjbpm.ultron.web.annotation.GenerateMenuGroup;
import cn.xjbpm.ultron.web.annotation.SecurityPermissions;
import cn.xjbpm.ultron.web.properties.UltronMvcProperties;
import cn.xjbpm.ultron.web.util.GenerateMenuUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=50)
@Aspect
@Component
public class SecurityPermissionsAspect {
    private static final Logger log = LoggerFactory.getLogger(SecurityPermissionsAspect.class);
    private final UltronMvcProperties ultronMvcProperties;

    @Pointcut(value="@annotation(securityPermissions)")
    public void pointCut(SecurityPermissions securityPermissions) {
    }

    @Around(value="pointCut(securityPermissions)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, SecurityPermissions securityPermissions) throws Throwable {
        if (this.ultronMvcProperties.getWebApiSecurity().booleanValue()) {
            OperatorUserVO operator = LoginUserUtil.getOperator();
            if (Objects.nonNull(operator) && CollUtil.isNotEmpty((Collection)operator.getPermissions())) {
                Class<?> declaringType = proceedingJoinPoint.getTarget().getClass();
                Map<String, Object> stringObjectMap = GenerateMenuUtil.buildContext(declaringType.getAnnotation(GenerateMenuGroup.class));
                List value = Stream.of(securityPermissions.value()).map(permission -> SpELUtil.parseValueToString((Map)stringObjectMap, (String)permission)).collect(Collectors.toList());
                boolean hasPermissions = false;
                if (securityPermissions.logic() == SecurityPermissions.Logic.OR) {
                    hasPermissions = value.stream().anyMatch(operator.getPermissions()::contains);
                } else if (securityPermissions.logic() == SecurityPermissions.Logic.AND) {
                    hasPermissions = value.stream().allMatch(operator.getPermissions()::contains);
                }
                if (hasPermissions) {
                    return proceedingJoinPoint.proceed();
                }
            }
            throw new BusinessSilenceException((ExceptionType)HttpStatusExceptionEnum.PERMISSION_DENY, new Object[0]);
        }
        return proceedingJoinPoint.proceed();
    }

    public SecurityPermissionsAspect(UltronMvcProperties ultronMvcProperties) {
        this.ultronMvcProperties = ultronMvcProperties;
    }
}

