/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.xjbpm.ultron.common.exception.BusinessSilenceException;
import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.exception.HttpStatusExceptionEnum;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.ElementKind;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Order(value=80)
@Aspect
@Component
public class RequestParameterValidationAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestParameterValidationAspect.class);
    private LocalValidatorFactoryBean localValidatorFactoryBean;

    @Autowired
    public void setLocalValidatorFactoryBean(LocalValidatorFactoryBean localValidatorFactoryBean) {
        this.localValidatorFactoryBean = localValidatorFactoryBean;
    }

    public RequestParameterValidationAspect() {
        log.info("init RequestParameterValidationAspect");
    }

    @Pointcut(value="(@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)) && execution(public * *(..))")
    public void controller() {
    }

    @Pointcut(value="execution(* cn.xjbpm.ultron.web.controller.CommonController.*(..))")
    public void method() {
    }

    @Before(value="controller() && method()")
    public void requestParameterValidate(JoinPoint joinPoint) {
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        this.paramValidate(joinPoint, errors);
        if (!errors.isEmpty()) {
            throw new BusinessSilenceException((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, StrUtil.join((CharSequence)",", (Object[])new Object[]{errors.values()}));
        }
    }

    public void paramValidate(JoinPoint joinPoint, Map<String, String> errors) {
        Object[] params = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            HashSet constraintViolations = CollUtil.newHashSet((Collection)this.localValidatorFactoryBean.forExecutables().validateParameters(target, method, params, new Class[0]));
            if (CollUtil.isEmpty((Collection)constraintViolations)) {
                Arrays.stream(params).filter(Objects::nonNull).forEach(param -> {
                    try {
                        constraintViolations.addAll(this.localValidatorFactoryBean.validate(param, new Class[0]));
                    }
                    catch (Exception e) {
                        log.error("\u672a\u8986\u76d6\u7684\u9a8c\u8bc1\u5904\u7406\u7c7b\uff0c\u5f02\u5e38\u7c7b\u578b:{}", e.getClass(), (Object)e);
                    }
                });
            }
            if (CollUtil.isNotEmpty((Collection)constraintViolations)) {
                constraintViolations.stream().forEach(constraintViolation -> {
                    PathImpl propertyPath = (PathImpl)constraintViolation.getPropertyPath();
                    String parameterName = propertyPath.toString();
                    if (propertyPath.getLeafNode().getKind() == ElementKind.PARAMETER) {
                        int parameterIndex = propertyPath.getLeafNode().getParameterIndex();
                        parameterName = signature.getParameterNames()[parameterIndex];
                    }
                    errors.put(parameterName, constraintViolation.getMessage());
                });
            }
        }
    }
}

