/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.hutool.crypto.digest.MD5;
import cn.xjbpm.ultron.common.exception.BusinessSilenceException;
import cn.xjbpm.ultron.common.exception.CommonExceptionEnum;
import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.util.JsonUtil;
import cn.xjbpm.ultron.common.util.RequestContextUtil;
import cn.xjbpm.ultron.redis.util.RedisTemplateUtil;
import cn.xjbpm.ultron.web.annotation.NoRepeatSubmit;
import cn.xjbpm.ultron.web.filter.RequestRepeatableWrapper;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Order(value=70)
@Aspect
@Component
public class RepeatSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(RepeatSubmitAspect.class);
    private static final String KEY_PREFIX = "noRepeatSubmit:";

    @Pointcut(value="@annotation(noRepeatSubmit)")
    public void pointCut(NoRepeatSubmit noRepeatSubmit) {
    }

    @Around(value="pointCut(noRepeatSubmit)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, NoRepeatSubmit noRepeatSubmit) throws Throwable {
        HttpServletRequest request = RequestContextUtil.getCurrentRequest().orElse(null);
        Assert.notNull((Object)request, (String)"request can not null");
        String token = request.getHeader("authorization");
        String path = request.getServletPath();
        String queryString = request.getQueryString();
        String formDataDigestHex = "";
        if (request instanceof RequestRepeatableWrapper) {
            formDataDigestHex = RequestContextUtil.isJsonRequest() ? MD5.create().digestHex((InputStream)request.getInputStream()) : JsonUtil.obj2Json((Object)request.getParameterMap());
        }
        String reidisKey = KEY_PREFIX + MD5.create().digestHex(String.format("%s%s%s%s", token, path, queryString, formDataDigestHex));
        int lockSeconds = noRepeatSubmit.lockTime();
        if (RedisTemplateUtil.setIfAbsent((String)reidisKey, (String)String.valueOf(Boolean.TRUE), (long)lockSeconds, (TimeUnit)TimeUnit.MILLISECONDS)) {
            return proceedingJoinPoint.proceed();
        }
        throw new BusinessSilenceException((ExceptionType)CommonExceptionEnum.REPEAT_REQUEST, new Object[0]);
    }
}

