/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.xjbpm.ultron.common.exception.BusinessSilenceException;
import cn.xjbpm.ultron.common.exception.CommonExceptionEnum;
import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.util.RequestContextUtil;
import cn.xjbpm.ultron.redis.util.RedisTemplateUtil;
import cn.xjbpm.ultron.web.annotation.Limit;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Order(value=90)
@Aspect
@Component
public class LimitAspect {
    private static final Logger log = LoggerFactory.getLogger(LimitAspect.class);
    private final RedisScript<Long> timeWindowLimitRedisScript;

    @Pointcut(value="@annotation(limit)")
    public void pointCut(Limit limit) {
    }

    @Around(value="pointCut(limit)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, Limit limit) throws Throwable {
        String redisKey;
        Long count;
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method signatureMethod = signature.getMethod();
        Limit.LimitType limitType = limit.limitType();
        String key = limit.key();
        if (StrUtil.isEmpty((CharSequence)key)) {
            if (limitType == Limit.LimitType.IP) {
                key = RequestContextUtil.getIpByReuqestHeader();
            } else if (limitType == Limit.LimitType.METHOD_NAME) {
                key = signatureMethod.getName();
            } else if (limitType == Limit.LimitType.FORM_DATA) {
                key = this.getParamsKey(proceedingJoinPoint.getArgs());
            }
        }
        if (Objects.nonNull(count = (Long)RedisTemplateUtil.execute(this.timeWindowLimitRedisScript, Arrays.asList(redisKey = StrUtil.join((CharSequence)":", (Object[])new Object[]{"limit", limitType.name(), key})), (Object[])new Object[]{limit.count(), limit.period()})) && count.intValue() <= limit.count()) {
            if (log.isDebugEnabled()) {
                log.debug("\u7b2c{}\u6b21\u8bbf\u95ee[{}]\u63a5\u53e3\uff0ckey\u4e3a{}", new Object[]{count, redisKey, limit.description()});
            }
            return proceedingJoinPoint.proceed();
        }
        throw new BusinessSilenceException((ExceptionType)CommonExceptionEnum.LIMIT_REQUEST, new Object[0]);
    }

    private String getParamsKey(Object[] args) {
        StringBuffer sb = new StringBuffer();
        for (Object arg : args) {
            sb.append("_" + arg.hashCode());
        }
        return SecureUtil.md5((String)sb.toString());
    }

    public LimitAspect(RedisScript<Long> timeWindowLimitRedisScript) {
        this.timeWindowLimitRedisScript = timeWindowLimitRedisScript;
    }
}

