/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.xjbpm.ultron.common.util.RequestContextUtil;
import cn.xjbpm.ultron.common.util.classmeta.ClassMeta;
import cn.xjbpm.ultron.common.util.classmeta.ClassMetaReader;
import cn.xjbpm.ultron.common.util.classmeta.MethodMeta;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Order(value=0)
@Aspect
@Component
public class ControllerLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerLogAspect.class);
    private static final Map<String, MethodMeta> CATCH_MAP = new HashMap<String, MethodMeta>();

    @Pointcut(value="(@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)) && execution(public * *(..))")
    public void controller() {
    }

    @Pointcut(value="execution(* cn.xjbpm.ultron.web.controller.CommonController.*(..))")
    public void method() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="controller() || method()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Optional currentRequest;
        if (log.isDebugEnabled() && (currentRequest = RequestContextUtil.getCurrentRequest()).isPresent()) {
            Object object;
            StopWatch stopWatch = new StopWatch();
            HttpServletRequest request = (HttpServletRequest)currentRequest.get();
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            String key = ClassMetaReader.getKey((Object)method);
            MethodMeta methodMeta = this.getMethodMeta(key, method, signature.getDeclaringType());
            try {
                log.debug("Found [{}] path={} : {}", new Object[]{request.getMethod(), request.getRequestURI(), methodMeta});
                stopWatch.start();
                object = joinPoint.proceed();
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                log.debug("time:{}ms for [{}] path={} ", new Object[]{stopWatch.getTotalTimeMillis(), request.getMethod(), request.getRequestURI()});
                throw throwable;
            }
            stopWatch.stop();
            log.debug("time:{}ms for [{}] path={} ", new Object[]{stopWatch.getTotalTimeMillis(), request.getMethod(), request.getRequestURI()});
            return object;
        }
        return joinPoint.proceed();
    }

    private MethodMeta getMethodMeta(String key, Method method, Class<?> clazz) {
        MethodMeta methodMeta = CATCH_MAP.get(key);
        if (Objects.isNull(methodMeta)) {
            ClassMeta classMeta = ClassMetaReader.buildWithClass(clazz);
            int lineNumber = (Integer)classMeta.methodLines.get(key);
            methodMeta = new MethodMeta(method, Integer.valueOf(lineNumber));
            CATCH_MAP.put(key, methodMeta);
        }
        return methodMeta;
    }
}

