/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.aspect;

import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.exception.HttpStatusExceptionEnum;
import cn.xjbpm.ultron.common.util.AssertUtils;
import cn.xjbpm.ultron.common.util.LoginUserUtil;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=40)
@Aspect
@Component
public class AuthenticationAspect {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationAspect.class);

    @Pointcut(value="@within(cn.xjbpm.ultron.web.annotation.ManageApi) || @within(cn.xjbpm.ultron.web.annotation.AppApi)")
    public void controller() {
    }

    @Pointcut(value="execution(public * *(..))")
    public void method() {
    }

    @Around(value="controller() && method()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Optional optionalOperator = LoginUserUtil.getOptionalOperator();
        AssertUtils.isTrue((boolean)optionalOperator.isPresent(), (ExceptionType)HttpStatusExceptionEnum.TOKEN_ERROR);
        return proceedingJoinPoint.proceed();
    }
}

