/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.web.advice;

import cn.hutool.core.util.StrUtil;
import cn.xjbpm.ultron.common.exception.BusinessSilenceException;
import cn.xjbpm.ultron.common.exception.CommonExceptionEnum;
import cn.xjbpm.ultron.common.exception.ExceptionType;
import cn.xjbpm.ultron.common.exception.HttpStatusExceptionEnum;
import cn.xjbpm.ultron.common.util.RequestContextUtil;
import cn.xjbpm.ultron.common.vo.JsonResultVO;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
@ControllerAdvice
public class GlobalExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionAdvice.class);

    @ExceptionHandler(value={BusinessSilenceException.class})
    @ResponseBody
    public JsonResultVO businessSilenceExceptionHandler(BusinessSilenceException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u9759\u9ed8\u5f02\u5e38\u4e0d\u4f5c\u4efb\u4f55\u8bb0\u5f55:", (Throwable)ex);
        }
        return new JsonResultVO(ex.getCode(), this.getErrorMsg((Exception)ex));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public JsonResultVO businessSilenceExceptionHandler(HttpMessageNotReadableException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u672a\u8bfb\u53d6\u5230\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4f53\uff0c\u6216\u53c2\u6570\u683c\u5f0f\u65e0\u6cd5\u89e3\u6790: {}", (Throwable)ex);
        }
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, (Object[])new Object[]{this.getErrorMsg((Exception)ex)});
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public JsonResultVO exceptionHandler(Exception ex) {
        if (ex instanceof BusinessSilenceException) {
            if (log.isDebugEnabled()) {
                log.debug("\u9759\u9ed8\u5f02\u5e38\u4e0d\u4f5c\u4efb\u4f55\u8bb0\u5f55:", (Throwable)ex);
            }
            return new JsonResultVO(((BusinessSilenceException)ex).getCode(), this.getErrorMsg(ex));
        }
        log.error("\u5168\u5c40\u5f02\u5e38", (Throwable)ex);
        return new JsonResultVO(HttpStatusExceptionEnum.SERVER_ERROR.getCode(), this.getErrorMsg(ex));
    }

    @ResponseBody
    @ExceptionHandler(value={DuplicateKeyException.class})
    public JsonResultVO exceptionHandler(DuplicateKeyException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u552f\u4e00\u7ea6\u675f\u5f15\u8d77\u7684\u5f02\u5e38: {}", (Throwable)ex);
        }
        return JsonResultVO.failed((ExceptionType)CommonExceptionEnum.DATA_DUPLICATION);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public JsonResultVO exceptionHandler(HttpRequestMethodNotSupportedException ex) {
        StringBuilder sb = new StringBuilder();
        Optional currentRequest = RequestContextUtil.getCurrentRequest();
        currentRequest.ifPresent(request -> sb.append(String.format("\u5f53\u524dURL: %s ", request.getRequestURI())));
        sb.append(String.format("\u5f53\u524durl\u652f\u6301\u8bf7\u6c42\u65b9\u5f0f\u4e3a:%s \u5f53\u524d\u63a5\u6536\u5230\u7684\u8bf7\u6c42\u65b9\u5f0f:%s", StrUtil.join((CharSequence)",", (Object[])ex.getSupportedMethods()), ex.getMethod()));
        if (log.isWarnEnabled()) {
            log.warn("\u60a8\u7684\u8bbe\u7f6e\u5b58\u5728\u95ee\u9898!!! {} ", (Object)sb);
        }
        return JsonResultVO.failed((String)sb.toString());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseBody
    public JsonResultVO illegalArgumentExceptionHandler(DataIntegrityViolationException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u6570\u636e\u5b8c\u6574\u6027\u5f02\u5e38: {}", (Throwable)ex);
        }
        return JsonResultVO.failed((ExceptionType)CommonExceptionEnum.DATA_INTEGRITY_VIOLATION_EXCEPTION);
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public JsonResultVO nullPointerExceptionHandler(NullPointerException ex) {
        log.error("\u7a7a\u6307\u9488\u5f02\u5e38:", (Throwable)ex);
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public JsonResultVO illegalArgumentExceptionHandler(IllegalArgumentException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38:", (Throwable)ex);
        }
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, (Object[])new Object[]{this.getErrorMsg(ex)});
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public JsonResultVO missingServletRequestParameterException(MissingServletRequestParameterException ex) {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38: {}", (Throwable)ex);
        }
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, (Object[])new Object[]{String.format("\u53c2\u6570[%s]\u662f\u5fc5\u987b\u7684\uff01", ex.getParameterName())});
    }

    @ExceptionHandler(value={MethodArgumentConversionNotSupportedException.class})
    @ResponseBody
    public JsonResultVO missingServletRequestParameterException(MethodArgumentConversionNotSupportedException ex) {
        if (log.isDebugEnabled()) {
            log.debug("spring\u65b9\u6cd5\u53c2\u6570\u8f6c\u6362\u4e0d\u652f\u6301\u7684\u5f02\u5e38: {}", (Throwable)ex);
        }
        MethodParameter parameter = ex.getParameter();
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, (Object[])new Object[]{String.format("\u53c2\u6570[%s]\u7c7b\u578b\u4e3a[%s],\u4f46\u4f20\u9012\u7684\u503c\u4e3a[%s]\uff01", parameter.getParameterName(), parameter.getParameterType(), ex.getValue())});
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public JsonResultVO missingServletRequestParameterException(MethodArgumentTypeMismatchException ex) {
        if (log.isDebugEnabled()) {
            log.debug("spring\u65b9\u6cd5\u53c2\u6570\u8f6c\u6362\u4e0d\u652f\u6301\u7684\u5f02\u5e38: {}", (Throwable)ex);
        }
        MethodParameter parameter = ex.getParameter();
        return JsonResultVO.failed((ExceptionType)HttpStatusExceptionEnum.PARAM_ERROR, (Object[])new Object[]{String.format("\u53c2\u6570[%s]\u7c7b\u578b\u4e3a[%s],\u4f46\u4f20\u9012\u7684\u503c\u4e3a[%s]\uff01", parameter.getParameterName(), parameter.getParameterType(), ex.getValue())});
    }

    private String getErrorMsg(Exception ex) {
        String errorMsg = ex.getMessage();
        if (ex instanceof BusinessSilenceException) {
            return ((BusinessSilenceException)ex).getDescription();
        }
        if (Objects.nonNull(ex.getCause()) && StrUtil.isNotBlank((CharSequence)ex.getCause().getMessage())) {
            errorMsg = ex.getCause().getMessage();
        }
        return errorMsg;
    }
}

