/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.groovy.script;

import cn.hutool.core.thread.ThreadUtil;
import cn.xjbpm.ultron.groovy.factory.GroovyFactory;
import cn.xjbpm.ultron.groovy.properties.GroovyProperties;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyScriptFactory;
import org.springframework.scripting.support.ScriptFactoryPostProcessor;

public abstract class GroovyScriptEngine
extends ScriptFactoryPostProcessor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GroovyScriptEngine.class);
    protected static final Map<String, String> ALL_SCRIPT_BEANS = new ConcurrentHashMap<String, String>();
    protected final DefaultListableBeanFactory defaultListableBeanFactory;
    protected final GroovyProperties groovyProperties;

    public GroovyScriptEngine(DefaultListableBeanFactory defaultListableBeanFactory, GroovyProperties groovyProperties) {
        this.defaultListableBeanFactory = defaultListableBeanFactory;
        this.groovyProperties = groovyProperties;
    }

    protected ScriptSource convertToScriptSource(String beanName, String scriptSourceLocator, ResourceLoader resourceLoader) {
        return this.getScriptSource(beanName, scriptSourceLocator, resourceLoader);
    }

    protected abstract ScriptSource getScriptSource(String var1, String var2, ResourceLoader var3);

    protected abstract void scanScript() throws IOException;

    public String register(File groovyFile) throws IOException {
        Class groovyClass = GroovyFactory.getInstance().compile(groovyFile);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)groovyClass).applyCustomizers(new BeanDefinitionCustomizer[]{bd -> {
            bd.setBeanClassName(GroovyScriptFactory.class.getName());
            bd.setAttribute(ScriptFactoryPostProcessor.LANGUAGE_ATTRIBUTE, (Object)"groovy");
            bd.setAttribute(ScriptFactoryPostProcessor.REFRESH_CHECK_DELAY_ATTRIBUTE, (Object)this.groovyProperties.getRefreshCheckDelaySecond());
            bd.setAutowireCandidate(true);
            bd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)groovyFile.getAbsolutePath());
        }});
        this.defaultListableBeanFactory.registerBeanDefinition(groovyClass.getSimpleName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        this.defaultListableBeanFactory.getDependentBeans(groovyClass.getSimpleName());
        return groovyClass.getSimpleName();
    }

    public String register(String code, String className) {
        Class groovyClass = GroovyFactory.getInstance().compile(code, className);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)groovyClass).applyCustomizers(new BeanDefinitionCustomizer[]{bd -> {
            bd.setBeanClassName(GroovyScriptFactory.class.getName());
            bd.setAttribute(ScriptFactoryPostProcessor.LANGUAGE_ATTRIBUTE, (Object)"groovy");
            bd.setAttribute(ScriptFactoryPostProcessor.REFRESH_CHECK_DELAY_ATTRIBUTE, (Object)this.groovyProperties.getRefreshCheckDelaySecond());
            bd.setAutowireCandidate(true);
            bd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)className);
        }});
        this.defaultListableBeanFactory.registerBeanDefinition(groovyClass.getSimpleName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        this.defaultListableBeanFactory.getDependentBeans(groovyClass.getSimpleName());
        return groovyClass.getSimpleName();
    }

    public void remove(String beanName) {
        this.defaultListableBeanFactory.removeBeanDefinition(beanName);
        this.defaultListableBeanFactory.clearMetadataCache();
    }

    public void afterPropertiesSet() {
        Thread thread = new Thread("ScanGroovyScriptListener"){

            @Override
            public void run() {
                while (GroovyScriptEngine.this.groovyProperties.getEnableScanScript().booleanValue()) {
                    try {
                        GroovyScriptEngine.this.scanScript();
                    }
                    catch (Exception e) {
                        log.error("\u626b\u63cf groovy \u811a\u672c\u5931\u8d25\uff01", (Throwable)e);
                    }
                    ThreadUtil.sleep((Number)GroovyScriptEngine.this.groovyProperties.getScanScriptSecond(), (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

