/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.groovy.script;

import cn.xjbpm.ultron.groovy.properties.GroovyProperties;
import cn.xjbpm.ultron.groovy.script.GroovyScriptEngine;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"groovy.script.dataBaseScriptSource"}, havingValue="false")
public class FileGroovyScriptEngine
extends GroovyScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(FileGroovyScriptEngine.class);

    public FileGroovyScriptEngine(DefaultListableBeanFactory defaultListableBeanFactory, GroovyProperties groovyProperties) {
        super(defaultListableBeanFactory, groovyProperties);
    }

    @Override
    protected ScriptSource getScriptSource(String beanName, String scriptSourceLocator, ResourceLoader resourceLoader) {
        return new ResourceScriptSource(resourceLoader.getResource(String.format("file:%s", scriptSourceLocator)));
    }

    @Override
    public void scanScript() throws IOException {
        String groovyDirectoryPath = GroovyScriptEngine.class.getClassLoader().getResource("groovy").getPath();
        File groovyDirectory = new File(groovyDirectoryPath);
        if (groovyDirectory.isDirectory()) {
            File[] groovyScript = groovyDirectory.listFiles((dir, name) -> name.endsWith(".groovy"));
            this.scanNewScriptAndAutoRegister(groovyScript);
            this.scanDeleteScriptAndAutoRemove(groovyScript);
        }
    }

    private void scanDeleteScriptAndAutoRemove(File[] scriptFiles) {
        ALL_SCRIPT_BEANS.forEach((fileName, beanName) -> {
            List collect = Arrays.stream(scriptFiles).map(File::getName).collect(Collectors.toList());
            if (!collect.contains(fileName)) {
                try {
                    this.remove((String)beanName);
                    ALL_SCRIPT_BEANS.remove(fileName);
                    log.info("\u811a\u672c{}\u5df2\u88ab\u79fb\u9664", fileName);
                }
                catch (Exception e) {
                    log.info("\u626b\u63cf\u5230\u79fb\u9664\u811a\u672c {}\uff0c\u4f46\u662f\u79fb\u9664\u5931\u8d25", fileName, (Object)e);
                }
            }
        });
    }

    private void scanNewScriptAndAutoRegister(File[] scriptFiles) throws IOException {
        for (File script : scriptFiles) {
            String scriptName = script.getName();
            if (ALL_SCRIPT_BEANS.containsKey(scriptName)) continue;
            try {
                String simpleBeanName = this.register(script);
                ALL_SCRIPT_BEANS.put(scriptName, simpleBeanName);
                log.info("\u811a\u672c{}\u6ce8\u518c\u5b8c\u6210,\u6587\u4ef6\u8def\u5f84 {}", (Object)script.getName(), (Object)script.getAbsolutePath());
            }
            catch (Exception e) {
                log.info("\u626b\u63cf\u5230\u65b0\u7684\u811a\u672c {}\uff0c\u4f46\u662f\u6ce8\u518c\u5931\u8d25", (Object)script.getName(), (Object)e);
                throw e;
            }
        }
    }
}

