/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.groovy.script;

import cn.xjbpm.ultron.groovy.repository.DataBaseScriptSourceRepository;
import java.time.LocalDateTime;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.StringUtils;

public class DataBaseScriptSource
implements ScriptSource {
    private final String scriptName;
    private final DataBaseScriptSourceRepository dataBaseScriptSourceRepository;
    private final Object lastModifiedMonitor = new Object();
    private LocalDateTime lastModifiedLocalDateTime;

    public DataBaseScriptSource(String scriptName, DataBaseScriptSourceRepository dataBaseScriptSourceRepository) {
        this.scriptName = scriptName;
        this.dataBaseScriptSourceRepository = dataBaseScriptSourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptAsString() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            this.lastModifiedLocalDateTime = LocalDateTime.now();
        }
        return this.dataBaseScriptSourceRepository.findScriptContent(this.scriptName, this.lastModifiedLocalDateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Object object = this.lastModifiedMonitor;
        synchronized (object) {
            return this.dataBaseScriptSourceRepository.checkModified(this.scriptName, this.lastModifiedLocalDateTime);
        }
    }

    public String suggestedClassName() {
        return StringUtils.stripFilenameExtension((String)this.scriptName);
    }
}

