/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.groovy.script;

import cn.xjbpm.ultron.groovy.entity.ScriptCode;
import cn.xjbpm.ultron.groovy.properties.GroovyProperties;
import cn.xjbpm.ultron.groovy.repository.DataBaseScriptSourceRepository;
import cn.xjbpm.ultron.groovy.script.DataBaseScriptSource;
import cn.xjbpm.ultron.groovy.script.GroovyScriptEngine;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.ScriptSource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"groovy.script.dataBaseScriptSource"}, havingValue="true")
public class DataBaseGroovyScriptEngine
extends GroovyScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(DataBaseGroovyScriptEngine.class);
    private final DataBaseScriptSourceRepository dataBaseScriptSourceRepository;

    public DataBaseGroovyScriptEngine(DefaultListableBeanFactory defaultListableBeanFactory, GroovyProperties groovyProperties, DataBaseScriptSourceRepository dataBaseScriptSourceRepository) {
        super(defaultListableBeanFactory, groovyProperties);
        this.dataBaseScriptSourceRepository = dataBaseScriptSourceRepository;
    }

    @Override
    protected ScriptSource getScriptSource(String beanName, String scriptSourceLocator, ResourceLoader resourceLoader) {
        return new DataBaseScriptSource(scriptSourceLocator, this.dataBaseScriptSourceRepository);
    }

    @Override
    public void scanScript() {
        Set<ScriptCode> scriptCodeSet = this.dataBaseScriptSourceRepository.findAllScriptCodeSet();
        this.scanNewScriptAndAutoRegister(scriptCodeSet);
        this.scanDeleteScriptAndAutoRemove(scriptCodeSet);
    }

    private void scanDeleteScriptAndAutoRemove(Set<ScriptCode> scriptCodeSet) {
        ALL_SCRIPT_BEANS.forEach((fileName, beanName) -> {
            List collect = scriptCodeSet.stream().map(ScriptCode::getCodeName).collect(Collectors.toList());
            if (!collect.contains(fileName)) {
                try {
                    this.remove((String)beanName);
                    ALL_SCRIPT_BEANS.remove(fileName);
                    log.info("\u811a\u672c{}\u5df2\u88ab\u79fb\u9664", fileName);
                }
                catch (Exception e) {
                    log.info("\u626b\u63cf\u5230\u79fb\u9664\u811a\u672c{}\uff0c\u4f46\u662f\u79fb\u9664\u5931\u8d25", fileName, (Object)e);
                }
            }
        });
    }

    private void scanNewScriptAndAutoRegister(Set<ScriptCode> scriptCodeSet) {
        for (ScriptCode script : scriptCodeSet) {
            String scriptName = script.getCodeName();
            if (ALL_SCRIPT_BEANS.containsKey(scriptName)) continue;
            try {
                String simpleBeanName = this.register(script.getCodeName(), script.getCodeContent());
                ALL_SCRIPT_BEANS.put(scriptName, simpleBeanName);
                log.info("\u811a\u672c{}\u6ce8\u518c\u5b8c\u6210", (Object)script.getCodeName());
            }
            catch (Exception e) {
                log.info("\u626b\u63cf\u5230\u65b0\u7684\u811a\u672c {}\uff0c\u4f46\u662f\u6ce8\u518c\u5931\u8d25", (Object)script.getCodeName(), (Object)e);
            }
        }
    }
}

