/*
 * Decompiled with CFR 0.152.
 */
package cn.xjbpm.ultron.groovy.factory;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import org.springframework.util.ClassUtils;

public class GroovyFactory {
    private static final GroovyFactory GROOVY_FACTORY = new GroovyFactory();
    private static final GroovyClassLoader GROOVY_CLASS_LOADER = new GroovyClassLoader(ClassUtils.getDefaultClassLoader());

    public static GroovyFactory getInstance() {
        return GROOVY_FACTORY;
    }

    public Class compile(File file) throws IOException {
        return GROOVY_CLASS_LOADER.parseClass(file);
    }

    public Class compile(String script, String name) {
        GroovyCodeSource groovyCodeSource = AccessController.doPrivileged(() -> new GroovyCodeSource(script, name, "/groovy/script"));
        return GROOVY_CLASS_LOADER.parseClass(groovyCodeSource);
    }
}

