/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.strategy.impl;

import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.UPLOADTYPE;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import cn.xisoil.service.manage.YueFileManageService;
import cn.xisoil.service.strategy.YueFileStrategy;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="LOCAL")
public class YueFileStrategyLocal
implements YueFileStrategy {
    @Autowired
    private YueFileManageService yueFileManageService;
    @Autowired
    private FileRepository fileRepository;

    @Override
    public R<String> upload(HttpServletRequest request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateNowStr = sdf.format(new Date());
        String fileDir = "resources" + File.separator + "upload" + File.separator + dateNowStr;
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        long fileSize = multipartFile.getSize();
        Object fileSizeString = "";
        fileSizeString = fileSize < 1024L ? String.valueOf(fileSize) + "B" : (fileSize < 0x100000L ? String.valueOf(fileSize / 1024L) + "KB" : (fileSize < 0x40000000L ? String.valueOf(fileSize / 0x100000L) + "MB" : String.valueOf(fileSize / 0x40000000L) + "GB"));
        String fileName = multipartFile.getOriginalFilename();
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String filename = dateNowStr + String.valueOf((int)(Math.random() * 1000000.0)) + "." + fileExt;
        String url = fileDir + File.separator + filename;
        File file = new File(url);
        try {
            multipartFile.transferTo(file.getAbsoluteFile());
        }
        catch (Exception e) {
            throw new NormalException("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef");
        }
        XisoilFile xisoilFile = new XisoilFile();
        xisoilFile.setSize((String)fileSizeString);
        xisoilFile.setFilename(fileName);
        xisoilFile.setUploadtype(UPLOADTYPE.LOCAL);
        xisoilFile.setUrl(File.separator + "upload" + File.separator + dateNowStr + File.separator + filename);
        this.yueFileManageService.save(xisoilFile);
        return R.builder().data((Object)(File.separator + "upload" + File.separator + dateNowStr + File.separator + filename)).success().build();
    }

    @Override
    @Transactional
    public R<String> delete(XisoilFile file) {
        File dir = new File("resources/" + file.getUrl());
        if (dir.exists()) {
            dir.delete();
        }
        return R.builder().success().message("\u5220\u9664\u6210\u529f").build();
    }
}

