/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.strategy.impl;

import cn.xisoil.dao.FileConfigRepository;
import cn.xisoil.data.FileInfo;
import cn.xisoil.data.UPLOADTYPE;
import cn.xisoil.data.UploadConfigClient;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.YueFileConfig;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import cn.xisoil.service.manage.YueFileManageService;
import cn.xisoil.service.strategy.YueFileStrategy;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="MINIO")
public class MinioFileStrategy
implements YueFileStrategy {
    @Autowired
    private YueFileManageService yueFileManageService;
    @Autowired
    private FileConfigRepository fileConfigRepository;

    @Override
    public R<String> upload(HttpServletRequest request) {
        YueFileConfig config = this.fileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartRequest.getFile("file");
            String fileName = multipartFile.getOriginalFilename();
            long fileSize = multipartFile.getSize();
            Object fileSizeString = "";
            fileSizeString = fileSize < 1024L ? String.valueOf(fileSize) + "B" : (fileSize < 0x100000L ? String.valueOf(fileSize / 1024L) + "KB" : (fileSize < 0x40000000L ? String.valueOf(fileSize / 0x100000L) + "MB" : String.valueOf(fileSize / 0x40000000L) + "GB"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateNowStr = sdf.format(new Date());
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            String objectName = dateNowStr + "-" + (int)(Math.random() * 1000000.0) + "." + fileExt;
            InputStream inputStream = multipartFile.getInputStream();
            String url = UploadConfigClient.of(config.getMinioEndpoint(), config.getMinioBucketName(), config.getMinioAk(), config.getMinioSk()).minio().upload(FileInfo.builder().name(objectName).inputStream(inputStream).build());
            XisoilFile xisoilFile = new XisoilFile();
            xisoilFile.setFilename(fileName);
            xisoilFile.setSize((String)fileSizeString);
            xisoilFile.setObjectName(objectName);
            xisoilFile.setUploadtype(UPLOADTYPE.MINIO);
            xisoilFile.setUrl(url);
            this.yueFileManageService.save(xisoilFile);
            return R.builder().data((Object)url).success().build();
        }
        catch (OSSException multipartRequest) {
        }
        catch (ClientException ce) {
            System.out.println("Error Message:" + ce.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new NormalException("\u672a\u77e5\u9519\u8bef");
    }

    @Override
    public R<String> delete(XisoilFile file) {
        YueFileConfig config = this.fileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());
        String objectName = file.getObjectName();
        UploadConfigClient.of(config.getMinioEndpoint(), config.getMinioBucketName(), config.getMinioAk(), config.getMinioSk()).minio().delete(objectName);
        return R.builder().success().message("\u5220\u9664\u6210\u529f").build();
    }
}

