/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.data;

import cn.xisoil.data.FileInfo;
import cn.xisoil.exception.FileUploadException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.obs.services.ObsConfiguration;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

public class UploadConfigClient {
    private final String endPoint;
    private final String bucketName;
    private final String ak;
    private final String sk;

    public OssClient oss() {
        return new OssClient().init();
    }

    public ObsClient obs() {
        return new ObsClient().init();
    }

    public MinioClient minio() {
        return new MinioClient().init();
    }

    private UploadConfigClient(String endPoint, String bucketName, String ak, String sk) {
        this.endPoint = endPoint;
        this.bucketName = bucketName;
        this.ak = ak;
        this.sk = sk;
    }

    public static UploadConfigClient of(String endPoint, String bucketName, String ak, String sk) {
        return new UploadConfigClient(endPoint, bucketName, ak, sk);
    }

    public class OssClient {
        private OSS oss;

        private OssClient init() {
            this.oss = new OSSClientBuilder().build(UploadConfigClient.this.endPoint, UploadConfigClient.this.ak, UploadConfigClient.this.sk);
            return this;
        }

        public String upload(FileInfo fileInfo) {
            if (StringUtils.isBlank((CharSequence)fileInfo.name)) {
                throw new FileUploadException("\u6587\u4ef6\u540d\u5f02\u5e38");
            }
            try {
                PutObjectRequest putObjectRequest;
                if (fileInfo.file != null) {
                    putObjectRequest = new PutObjectRequest(UploadConfigClient.this.bucketName, fileInfo.name, fileInfo.file);
                } else if (fileInfo.inputStream != null) {
                    putObjectRequest = new PutObjectRequest(UploadConfigClient.this.bucketName, fileInfo.name, fileInfo.inputStream);
                } else if (StringUtils.isNotBlank((CharSequence)fileInfo.content)) {
                    putObjectRequest = new PutObjectRequest(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)new ByteArrayInputStream(fileInfo.content.getBytes()));
                } else if (fileInfo.bytes != null) {
                    putObjectRequest = new PutObjectRequest(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)new ByteArrayInputStream(fileInfo.bytes));
                } else if (fileInfo.byteArrayInputStream != null) {
                    putObjectRequest = new PutObjectRequest(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)fileInfo.byteArrayInputStream);
                } else {
                    throw new FileUploadException("\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
                }
                putObjectRequest.setProcess("true");
                PutObjectResult result = this.oss.putObject(putObjectRequest);
                return result.getResponse().getUri();
            }
            catch (Exception e) {
                throw new FileUploadException(e.getMessage());
            }
        }

        public Boolean delete(String fileName) {
            return this.oss.deleteObject(UploadConfigClient.this.bucketName, fileName).getResponse().isSuccessful();
        }
    }

    public class ObsClient {
        private static com.obs.services.ObsClient obs;

        private ObsClient init() {
            ObsConfiguration config = new ObsConfiguration();
            config.setSocketTimeout(30000);
            config.setConnectionTimeout(10000);
            config.setEndPoint(UploadConfigClient.this.endPoint);
            obs = new com.obs.services.ObsClient(UploadConfigClient.this.ak, UploadConfigClient.this.sk, config);
            return this;
        }

        public String upload(FileInfo fileInfo) {
            if (StringUtils.isBlank((CharSequence)fileInfo.name)) {
                throw new FileUploadException("\u6587\u4ef6\u540d\u5f02\u5e38");
            }
            try {
                com.obs.services.model.PutObjectResult result;
                if (fileInfo.file != null) {
                    result = obs.putObject(UploadConfigClient.this.bucketName, fileInfo.name, fileInfo.file);
                } else if (fileInfo.inputStream != null) {
                    result = obs.putObject(UploadConfigClient.this.bucketName, fileInfo.name, fileInfo.inputStream);
                } else if (StringUtils.isNotBlank((CharSequence)fileInfo.content)) {
                    result = obs.putObject(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)new ByteArrayInputStream(fileInfo.content.getBytes()));
                } else if (fileInfo.bytes != null) {
                    result = obs.putObject(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)new ByteArrayInputStream(fileInfo.bytes));
                } else if (fileInfo.byteArrayInputStream != null) {
                    result = obs.putObject(UploadConfigClient.this.bucketName, fileInfo.name, (InputStream)fileInfo.byteArrayInputStream);
                } else {
                    throw new FileUploadException("\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
                }
                return result.getObjectUrl();
            }
            catch (Exception e) {
                throw new FileUploadException(e.getMessage());
            }
        }

        public Boolean delete(String fileName) {
            return obs.deleteObject(UploadConfigClient.this.bucketName, fileName).isDeleteMarker();
        }
    }

    public class MinioClient {
        private static io.minio.MinioClient minio;

        private MinioClient init() {
            try {
                minio = new MinioClient.Builder().endpoint(UploadConfigClient.this.endPoint).credentials(UploadConfigClient.this.ak, UploadConfigClient.this.sk).build();
                return this;
            }
            catch (Exception e) {
                throw new FileUploadException("MinIo \u521d\u59cb\u5316\u5931\u8d25");
            }
        }

        public String upload(FileInfo fileInfo) {
            if (StringUtils.isBlank((CharSequence)fileInfo.name)) {
                throw new FileUploadException("\u6587\u4ef6\u540d\u5f02\u5e38");
            }
            try {
                InputStream inputStream;
                if (fileInfo.file != null) {
                    inputStream = new FileInputStream(fileInfo.file);
                } else if (fileInfo.inputStream != null) {
                    inputStream = fileInfo.inputStream;
                } else if (StringUtils.isNotBlank((CharSequence)fileInfo.content)) {
                    inputStream = new ByteArrayInputStream(fileInfo.content.getBytes());
                } else if (fileInfo.bytes != null) {
                    inputStream = new ByteArrayInputStream(fileInfo.bytes);
                } else if (fileInfo.byteArrayInputStream != null) {
                    inputStream = fileInfo.byteArrayInputStream;
                } else {
                    throw new FileUploadException("\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38");
                }
                ObjectWriteResponse result = minio.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(UploadConfigClient.this.bucketName)).object(fileInfo.name)).stream(inputStream, (long)inputStream.available(), -1L).build());
                return UploadConfigClient.this.endPoint + "/" + UploadConfigClient.this.bucketName + "/" + fileInfo.name;
            }
            catch (Exception e) {
                throw new FileUploadException(e.getMessage());
            }
        }

        public Boolean delete(String fileName) {
            try {
                minio.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(UploadConfigClient.this.bucketName)).object(fileName)).build());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

