/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.controller;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.manage.YueFileManageService;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/manage/file"})
@RestController
public class FileManageController
extends ModelCurdControllerMapping<XisoilFile, FileRepository> {
    @Autowired
    private YueFileManageService yueFileManageService;

    @GetMapping(value={"/type"})
    @Log(value="\u83b7\u53d6\u6587\u4ef6\u5206\u7c7b")
    public R<List<Map<String, String>>> type() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        list.add(Map.of("id", "IMAGE", "title", "\u56fe\u7247"));
        list.add(Map.of("id", "DOC", "title", "\u6587\u6863"));
        list.add(Map.of("id", "RAR", "title", "\u538b\u7f29\u5305"));
        list.add(Map.of("id", "VIDEO", "title", "\u89c6\u9891"));
        list.add(Map.of("id", "AUDIO", "title", "\u97f3\u9891"));
        list.add(Map.of("id", "PROGRAM", "title", "\u6267\u884c\u6587\u4ef6"));
        list.add(Map.of("id", "OTHER", "title", "\u5176\u4ed6\u6587\u4ef6"));
        return R.builder().data(list).success().build();
    }

    @PostMapping(value={"/delete"})
    @Primary
    @Log(value="\u5220\u9664\u6587\u4ef6")
    protected R<String> delete(@Valid @RequestBody ListStringRequest stringRequest, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(Integer.valueOf(500)).message(error.getDefaultMessage()).build();
        }
        return this.yueFileManageService.delete(stringRequest);
    }

    public String getUrl() {
        return "/file";
    }

    public String getName() {
        return "\u5a92\u4f53\u670d\u52a1";
    }

    public String getParent() {
        return "\u6587\u4ef6\u7ba1\u7406";
    }
}

