/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.manage.impl;

import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.service.manage.YueFileManageService;
import cn.xisoil.service.strategy.YueFileStrategy;
import cn.xisoil.utils.YueFileExtract;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class YueFileManageServiceImpl
implements YueFileManageService {
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    @Lazy
    private Map<String, YueFileStrategy> yueFileConfigMap = new HashMap<String, YueFileStrategy>();

    @Override
    public void save(XisoilFile xisoilFile) {
        xisoilFile.setType(YueFileExtract.getType(xisoilFile.getFilename().substring(xisoilFile.getFilename().lastIndexOf(".") + 1)));
        this.fileRepository.save(xisoilFile);
    }

    @Override
    @Transactional
    public R<String> delete(ListStringRequest request) {
        List<XisoilFile> files = this.fileRepository.findUrlByIdIn(request.getIds());
        this.fileRepository.deleteAllByIdIn(request.getIds());
        files.forEach(file -> this.yueFileConfigMap.get(file.getUploadtype().getType()).delete((XisoilFile)file));
        return R.builder().success().message("\u5220\u9664\u6210\u529f").build();
    }
}

