package cn.xisoil.service.upload.impl;

import cn.xisoil.dao.FileConfigRepository;
import cn.xisoil.data.YueFileConfig;
import cn.xisoil.data.result.R;
import cn.xisoil.service.upload.UploadFileService;
import cn.xisoil.service.strategy.YueFileStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import jakarta.servlet.http.HttpServletRequest;
import java.util.*;

@Service
public class UploadFileServiceImpl implements UploadFileService {

    @Autowired
    private FileConfigRepository fileConfigRepository;

    @Autowired
    private Map<String, YueFileStrategy> yueFileConfigMap=new HashMap<>();

    @Override
    public R<String> upload(HttpServletRequest request) {
        YueFileConfig yueFileConfig= fileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());
       return yueFileConfigMap.get(yueFileConfig.getUploadtype().getType()).upload(request);

    }



}
