package cn.xisoil.service.strategy.impl;


import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.UPLOADTYPE;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import cn.xisoil.service.strategy.YueFileStrategy;
import cn.xisoil.service.manage.YueFileManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

@Service(value = "LOCAL")
public class YueFileStrategyLocal implements YueFileStrategy {


    @Autowired
    private YueFileManageService yueFileManageService;
    @Autowired
    private FileRepository fileRepository;

    @Override
    public R<String> upload(HttpServletRequest request) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateNowStr = sdf.format(new Date());
        String fileDir="resources"+ File.separator+"upload"+File.separator+dateNowStr;
        File dir=new File(fileDir);
        if (!dir.exists()){
            dir.mkdirs();
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        MultipartFile multipartFile=multipartRequest.getFile("file");

        //获取文件大小
        long fileSize = multipartFile.getSize();
        //文件大小转KB,MB,GB
        String fileSizeString = "";
        if (fileSize < 1024) {
            fileSizeString = String.valueOf(fileSize) + "B";
        } else if (fileSize < 1048576) {
            fileSizeString = String.valueOf(fileSize / 1024) + "KB";
        } else if (fileSize < 1073741824) {
            fileSizeString = String.valueOf(fileSize / 1048576) + "MB";
        } else {
            fileSizeString = String.valueOf(fileSize / 1073741824) + "GB";
        }

        String fileName= multipartFile.getOriginalFilename();
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String filename=dateNowStr+String.valueOf((int)(Math.random() * 1000000))+"."+fileExt;//随机文件名
        String url=fileDir+File.separator+filename;
        File file = new File(url);
        try{
            multipartFile.transferTo(file.getAbsoluteFile());
        }
        catch (Exception e){
            throw new NormalException("上传失败，未知错误");
        }
        XisoilFile xisoilFile =new XisoilFile();
        xisoilFile.setSize(fileSizeString);
        xisoilFile.setFilename(fileName);
        xisoilFile.setUploadtype(UPLOADTYPE.LOCAL);
        xisoilFile.setUrl(File.separator+"upload"+File.separator+dateNowStr+File.separator+filename);
        yueFileManageService.save(xisoilFile);
        return R.<String>builder()
                .data(File.separator+"upload"+File.separator+dateNowStr+File.separator+filename)
                .success().build();
    }

    @Override
    @Transactional
    public R<String> delete(XisoilFile file) {
        File dir=new File("resources/"+file.getUrl());
        if (dir.exists()){
            dir.delete();
        }
        return R.<String>builder().success().message("删除成功").build();
    }

}
