package cn.xisoil.service.strategy.impl;


import cn.xisoil.dao.FileConfigRepository;
import cn.xisoil.data.FileInfo;
import cn.xisoil.data.UploadConfigClient;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.NormalException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import cn.xisoil.data.UPLOADTYPE;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.YueFileConfig;
import cn.xisoil.service.strategy.YueFileStrategy;
import cn.xisoil.service.manage.YueFileManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

@Service(value = "ALYOSS")
public class OssFileStrategy implements YueFileStrategy {

    @Autowired
    private YueFileManageService yueFileManageService;
    @Autowired
    private FileConfigRepository fileConfigRepository;


    @Override
    public R<String> upload(HttpServletRequest request) {
        YueFileConfig config= fileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());

        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            MultipartFile multipartFile=multipartRequest.getFile("file");
            String fileName= multipartFile.getOriginalFilename();

            //获取文件大小
            long fileSize = multipartFile.getSize();
            //文件大小转KB,MB,GB
            String fileSizeString = "";
            if (fileSize < 1024) {
                fileSizeString = String.valueOf(fileSize) + "B";
            } else if (fileSize < 1048576) {
                fileSizeString = String.valueOf(fileSize / 1024) + "KB";
            } else if (fileSize < 1073741824) {
                fileSizeString = String.valueOf(fileSize / 1048576) + "MB";
            } else {
                fileSizeString = String.valueOf(fileSize / 1073741824) + "GB";
            }

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateNowStr = sdf.format(new Date());
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            String objectName=dateNowStr+"-"+(int)(Math.random() * 1000000)+"."+fileExt;//随机文件名
            InputStream inputStream =multipartFile.getInputStream();
            String url= UploadConfigClient
                    .of(config.getOssEndpoint(), config.getOssBucketName(), config.getOssAk(), config.getOssSk())
                    .oss().upload(FileInfo.builder().name(objectName).inputStream(inputStream).build());
            XisoilFile xisoilFile =new XisoilFile();
            xisoilFile.setFilename(fileName);
            xisoilFile.setObjectName(objectName);
            xisoilFile.setSize(fileSizeString);
            xisoilFile.setUploadtype(UPLOADTYPE.ALYOSS);
            xisoilFile.setUrl(url);
            yueFileManageService.save(xisoilFile);
            return R.<String>builder()
                    .data(url)
                    .success().build();
        } catch (OSSException oe) {
        } catch (ClientException ce) {
            System.out.println("Error Message:" + ce.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
        }
        throw new NormalException("未知错误");
    }

    @Override
    public R<String> delete(XisoilFile file) {
        YueFileConfig config= fileConfigRepository.findTopByIdNotNull().orElse(new YueFileConfig());
        // 填写文件完整路径。文件完整路径中不能包含Bucket名称。
        String objectName = file.getObjectName();

        // 创建OSSClient实例。
        UploadConfigClient
                .of(config.getOssEndpoint(), config.getOssBucketName(), config.getOssAk(), config.getOssSk())
                .oss().delete(objectName);

        return R.<String>builder().success().message("删除成功").build();
    }
}
