package cn.xisoil.service.manage.impl;

import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.service.manage.YueFileManageService;
import cn.xisoil.service.strategy.YueFileStrategy;
import cn.xisoil.utils.YueFileExtract;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class YueFileManageServiceImpl implements YueFileManageService {

    @Autowired
    private FileRepository fileRepository;

    @Autowired
    @Lazy
    private Map<String, YueFileStrategy> yueFileConfigMap=new HashMap<>();


    @Override
    public void save(XisoilFile xisoilFile) {
        xisoilFile.setType(YueFileExtract
                .getType(xisoilFile.getFilename()
                        .substring(xisoilFile
                                .getFilename()
                                .lastIndexOf(".")+1
                        )
                )
        );
        fileRepository.save(xisoilFile);
    }

    @Override
    @Transactional
    public R<String> delete(ListStringRequest request) {

        List<XisoilFile> files= fileRepository.findUrlByIdIn(request.getIds());
        fileRepository.deleteAllByIdIn(request.getIds());
        files.forEach(file->{
            yueFileConfigMap.get(file.getUploadtype().getType()).delete(file);
        });

        return R.<String>builder().success().message("删除成功").build();
    }
}
