package cn.xisoil.data;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import jakarta.persistence.*;

@Entity(name = "YueFileConfig")
@Table(name = "yue_file_config")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "文件配置",add = false,edit = false)
public class YueFileConfig {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @Enumerated(value = EnumType.STRING)
    @CurdModel(value = "存储方式",type = ObjectColumnType.LIST,url = "/file/config/type")
    private UPLOADTYPE uploadtype=UPLOADTYPE.LOCAL;

    @CurdModel(value = "文件节点",group = "阿里云存储")
    private String ossEndpoint;

    @CurdModel(value = "KEY ID",group = "阿里云存储")
    private String ossAk;

    @CurdModel(value = "密钥",group = "阿里云存储")
    private String ossSk;

    @CurdModel(value = "通道名称",group = "阿里云存储")
    private String ossBucketName;


    @CurdModel(value = "文件节点",group = "华为云存储")
    private String obsEndpoint;

    @CurdModel(value = "KEY ID",group = "华为云存储")
    private String obsAk;

    @CurdModel(value = "密钥",group = "华为云存储")
    private String obsSk;

    @CurdModel(value = "通道名称",group = "华为云存储")
    private String obsBucketName;


    @CurdModel(value = "文件节点",group = "MINIO云存储")
    private String minioEndpoint;

    @CurdModel(value = "KEY ID",group = "MINIO云存储")
    private String minioAk;

    @CurdModel(value = "密钥",group = "MINIO云存储")
    private String minioSk;

    @CurdModel(value = "通道名称",group = "MINIO云存储")
    private String minioBucketName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UPLOADTYPE getUploadtype() {
        return uploadtype;
    }

    public void setUploadtype(UPLOADTYPE uploadtype) {
        this.uploadtype = uploadtype;
    }

    public String getOssEndpoint() {
        return ossEndpoint;
    }

    public void setOssEndpoint(String ossEndpoint) {
        this.ossEndpoint = ossEndpoint;
    }

    public String getOssAk() {
        return ossAk;
    }

    public void setOssAk(String ossAk) {
        this.ossAk = ossAk;
    }

    public String getOssSk() {
        return ossSk;
    }

    public void setOssSk(String ossSk) {
        this.ossSk = ossSk;
    }

    public String getOssBucketName() {
        return ossBucketName;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public String getObsEndpoint() {
        return obsEndpoint;
    }

    public void setObsEndpoint(String obsEndpoint) {
        this.obsEndpoint = obsEndpoint;
    }

    public String getObsAk() {
        return obsAk;
    }

    public void setObsAk(String obsAk) {
        this.obsAk = obsAk;
    }

    public String getObsSk() {
        return obsSk;
    }

    public void setObsSk(String obsSk) {
        this.obsSk = obsSk;
    }

    public String getObsBucketName() {
        return obsBucketName;
    }

    public void setObsBucketName(String obsBucketName) {
        this.obsBucketName = obsBucketName;
    }

    public String getMinioEndpoint() {
        return minioEndpoint;
    }

    public void setMinioEndpoint(String minioEndpoint) {
        this.minioEndpoint = minioEndpoint;
    }

    public String getMinioAk() {
        return minioAk;
    }

    public void setMinioAk(String minioAk) {
        this.minioAk = minioAk;
    }

    public String getMinioSk() {
        return minioSk;
    }

    public void setMinioSk(String minioSk) {
        this.minioSk = minioSk;
    }

    public String getMinioBucketName() {
        return minioBucketName;
    }

    public void setMinioBucketName(String minioBucketName) {
        this.minioBucketName = minioBucketName;
    }
}
