package cn.xisoil.data;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import jakarta.persistence.*;
import java.util.Date;

@Entity(name = "XisoilFile")
@Table(name = "xisoil_file")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "文件管理",add = false,edit = false)
public class XisoilFile {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CreatedDate
    @CurdModel(value = "上传时间")
    private Date createTime;

    @Enumerated(value = EnumType.STRING)
    @CurdModel(value = "存储方式",type = ObjectColumnType.LIST,url = "/file/config/type")
    private UPLOADTYPE uploadtype=UPLOADTYPE.LOCAL;

    public UPLOADTYPE getUploadtype() {
        return uploadtype==null?UPLOADTYPE.LOCAL:uploadtype;
    }

    @CurdModel(value = "文件名")
    private String filename;

    //文件大小
    @CurdModel(value = "文件大小")
    private String size;

    private String objectName;

    @CurdModel(value = "文件地址",type = ObjectColumnType.FILE)
    private String url;

    @CurdModel(value = "文件类型",type = ObjectColumnType.LIST,url = "/file/type",search = true)
    @Enumerated(EnumType.STRING)
    private YueFileType type;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUploadtype(UPLOADTYPE uploadtype) {
        this.uploadtype = uploadtype;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getObjectName() {
        return objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public YueFileType getType() {
        return type;
    }

    public void setType(YueFileType type) {
        this.type = type;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }
}
