package cn.xisoil.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-03-2023/3/9 17:12:31
 **/

public class FileInfo{

    public String name;

    public File file;

    public InputStream inputStream;

    public String content;

    public byte[] bytes;

    public ByteArrayInputStream byteArrayInputStream;


    public FileInfo(String name, File file, InputStream inputStream, String content, byte[] bytes, ByteArrayInputStream byteArrayInputStream) {
        this.name = name;
        this.file = file;
        this.inputStream = inputStream;
        this.content = content;
        this.bytes = bytes;
        this.byteArrayInputStream = byteArrayInputStream;
    }

    private FileInfo(Builder builder) {
        setName(builder.name);
        setFile(builder.file);
        setInputStream(builder.inputStream);
        setContent(builder.content);
        setBytes(builder.bytes);
        setByteArrayInputStream(builder.byteArrayInputStream);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        return byteArrayInputStream;
    }

    public void setByteArrayInputStream(ByteArrayInputStream byteArrayInputStream) {
        this.byteArrayInputStream = byteArrayInputStream;
    }

    public static Builder builder(){
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private File file;
        private InputStream inputStream;
        private String content;
        private byte[] bytes;
        private ByteArrayInputStream byteArrayInputStream;

        public Builder() {
        }

        public Builder name(String val) {
            name = val;
            return this;
        }

        public Builder file(File val) {
            file = val;
            return this;
        }

        public Builder inputStream(InputStream val) {
            inputStream = val;
            return this;
        }

        public Builder content(String val) {
            content = val;
            return this;
        }

        public Builder bytes(byte[] val) {
            bytes = val;
            return this;
        }

        public Builder byteArrayInputStream(ByteArrayInputStream val) {
            byteArrayInputStream = val;
            return this;
        }

        public FileInfo build() {
            return new FileInfo(this);
        }
    }
}
