package cn.xisoil.controller;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.dao.FileRepository;
import cn.xisoil.data.XisoilFile;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.manage.YueFileManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequestMapping("/manage/file")
@RestController
public class FileManageController extends ModelCurdControllerMapping<XisoilFile, FileRepository> {

    @Autowired
    private YueFileManageService yueFileManageService;

    @GetMapping("/type")
    @Log("获取文件分类")
    public R<List<Map<String,String>>> type(){
        List<Map<String,String>>list=new ArrayList<>();
        list.add(Map.of("id","IMAGE","title","图片"));
        list.add(Map.of("id","DOC","title","文档"));
        list.add(Map.of("id","RAR","title","压缩包"));
        list.add(Map.of("id","VIDEO","title","视频"));
        list.add(Map.of("id","AUDIO","title","音频"));
        list.add(Map.of("id","PROGRAM","title","执行文件"));
        list.add(Map.of("id","OTHER","title","其他文件"));
        return R.<List<Map<String, String>>>builder().data(list).success().build();
    }


    @PostMapping("/delete")
    @Primary
    @Log("删除文件")
    protected R<String> delete(@Valid @RequestBody ListStringRequest stringRequest, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return  yueFileManageService.delete(stringRequest);
    }

    @Override
    public String getUrl() {
        return "/file";
    }

    @Override
    public String getName() {
        return "媒体服务";
    }

    @Override
    public String getParent() {
        return "文件管理";
    }
}
