package com.vien.entity;

import cn.xisoil.annotation.batch.BatchSQLDelete;
import cn.xisoil.annotation.model.*;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.enums.ObjectType;
import jakarta.persistence.*;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.*;
//import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-03-2023/3/22 21:31:36
 **/
@Entity(name = "Member")
@Table(name = "member")
@CurdModelObject(value = "测试管理",trusteeship = @CurdTrusteeShipObject(type = ObjectType.SINGLE),permission = @PermissionTrusteeShipObject(key = ""))
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "del_flag = 0 || del_flag is null")
@BatchSQLDelete(value = "update member set del_flag = 1 where id in ?",nativeQuery = true)
public class Member {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "用户名",search = true)
    private String name;

    @CurdModel(value = "年龄",comparable = true)
    private Integer age;

    @CurdModel(value = "手机")
    private String phone;
    @CurdModel(value = "性别")
    @DataDict("sex")
    private String sex;

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    @CurdModel(value = "添加时间",type = ObjectColumnType.DATE,editor = false)
    private Date createTime;

    private Boolean delFlag = false;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
