package cn.xisoil.controller.member;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.dao.member.MemberRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.SingleModelController;
import com.vien.entity.Member;
import jakarta.validation.Valid;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("/manage/member")
@RestController("MemberController")
public class MemberController extends SingleModelController<Member, MemberRepository> {
  @Log("获取测试管理详情")
  @GetMapping("")
  public R get() {
    return super.get();
  }

  @PutMapping("")
  @Log("修改测试管理")
  public R edit(@Valid @RequestBody Member request, BindingResult result) {
    return super.edit(request);
  }
}
