package com.vien.entity;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.annotation.model.CurdTrusteeShipObject;
import cn.xisoil.annotation.model.PermissionTrusteeShipObject;
import cn.xisoil.data.enums.ObjectColumnType;
import jakarta.persistence.*;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.*;
//import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-03-2023/3/22 21:31:36
 **/
@Entity(name = "Adb")
@Table(name = "Adb")
@CurdModelObject(value = "BUG管理",permission = @PermissionTrusteeShipObject(key = "",auto = true,parent = "测试管理"),
        trusteeship = @CurdTrusteeShipObject(auto = false)
)
@EntityListeners(AuditingEntityListener.class)
public class Adb {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;


    @CurdModel(value = "标题")
    private String title;


    @CurdModel(value = "是否删除",type = ObjectColumnType.BOOLEAN)
    private Boolean deleted;

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
