/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils;

import cn.xisoil.exception.NormalException;
import cn.xisoil.utils.SpringContextUtils;
import cn.xisoil.utils.TaskService;
import cn.xisoil.utils.TaskServiceConstructor;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TaskTools {
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    private final Map<String, TaskService> taskServices = new HashMap<String, TaskService>();
    private Map<String, TaskServiceConstructor> taskServiceMap = new HashMap<String, TaskServiceConstructor>();
    ScheduledExecutorService executorService = Executors.newScheduledThreadPool(100);

    @Autowired
    @Lazy
    public void setTaskServices() {
        List taskServiceList = this.springContextUtils.getBeansForType(TaskService.class);
        taskServiceList.forEach(taskService -> this.taskServices.put(taskService.getTaskName(), (TaskService)taskService));
    }

    @PostConstruct
    private void init() {
        this.taskServices.forEach((k, v) -> this.setSchedule((TaskService)v));
    }

    public void setSchedule(TaskService taskService) {
        ScheduledFuture schedule = this.threadPoolTaskScheduler.schedule((Runnable)taskService, (Trigger)new CronTrigger(taskService.getCron()));
        this.taskServiceMap.put(taskService.getTaskName(), new TaskServiceConstructor(taskService, schedule));
    }

    public void close(String taskId) {
        TaskServiceConstructor taskServiceConstructor = this.taskServiceMap.get(taskId);
        taskServiceConstructor.close();
    }

    public void refreshCron(String taskId, String cron) {
        this.close(taskId);
        TaskService taskService = this.taskServiceMap.get(taskId).getTaskService();
        taskService.setCron(cron);
        ScheduledFuture schedule = this.threadPoolTaskScheduler.schedule((Runnable)taskService, (Trigger)new CronTrigger(cron));
        this.taskServiceMap.put(taskService.getTaskName(), new TaskServiceConstructor(taskService, schedule));
    }

    public void run(String taskId) {
        this.taskServiceMap.get(taskId).run();
    }

    public void start(String taskId) {
        TaskServiceConstructor taskServiceConstructor = this.taskServiceMap.get(taskId);
        if (!taskServiceConstructor.getCancelled().booleanValue()) {
            throw new NormalException("\u8bf7\u52ff\u91cd\u590d\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1");
        }
        ScheduledFuture schedule = this.threadPoolTaskScheduler.schedule((Runnable)taskServiceConstructor.getTaskService(), (Trigger)new CronTrigger(taskServiceConstructor.getTaskService().getCron()));
        this.taskServiceMap.put(taskId, new TaskServiceConstructor(taskServiceConstructor.getTaskService(), schedule));
    }

    public void runAll() {
        this.taskServiceMap.values().forEach(TaskServiceConstructor::run);
    }

    public List<TaskServiceConstructor> tasks() {
        return this.taskServiceMap.values().stream().toList();
    }
}

