/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils;

import cn.xisoil.utils.TaskService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TaskServiceConstructor {
    private TaskService taskService;
    private ScheduledFuture<?> schedule;

    public TaskServiceConstructor() {
    }

    public TaskServiceConstructor(TaskService taskService, ScheduledFuture<?> schedule) {
        this.taskService = taskService;
        this.schedule = schedule;
    }

    public void run() {
        this.taskService.run();
    }

    void close() {
        this.schedule.cancel(true);
    }

    public Boolean getDone() {
        return this.schedule.isDone();
    }

    public String getNextTime() {
        long secondCount = this.schedule.getDelay(TimeUnit.SECONDS);
        long day = secondCount / 86400L;
        long hour = secondCount / 3600L - day * 24L;
        long min = secondCount / 60L - day * 24L * 60L - hour * 60L;
        long second = secondCount - min * 60L - hour * 60L * 60L - day * 24L * 60L * 60L;
        return day + "\u5929" + hour + "\u65f6" + min + "\u5206\u949f" + second + "\u79d2";
    }

    public Boolean getCancelled() {
        return this.schedule.isCancelled();
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public ScheduledFuture<?> getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScheduledFuture<?> schedule) {
        this.schedule = schedule;
    }
}

