package cn.xisoil.controller;


import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.result.R;
import cn.xisoil.dto.TaskEditRequest;
import cn.xisoil.utils.TaskServiceConstructor;
import cn.xisoil.utils.TaskTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/manage/task")
public class YueTaskController  implements PermissionCheckAutomation {

    @Override
    public String getUrl() {
        return "/task";
    }

    @Override
    public String getName() {
        return "任务列表";
    }

    @Override
    public String getParent() {
        return "计划任务";
    }

    @Override
    public boolean auto() {
        return true;
    }

    @Autowired
    private TaskTools taskTools;

    @PostMapping("/list")
    public R<List<TaskServiceConstructor>> getTask(){
        List<TaskServiceConstructor>taskServices=taskTools.tasks();
        return R.<List<TaskServiceConstructor>>builder().success().data(taskServices).build();
    }

    @PatchMapping("/cancel/{id}")
    public R<String> cancel(@PathVariable String id){
        taskTools.close(id);
        return R.<String>builder().success().message("关闭成功").build();
    }

    @PutMapping("")
    public R<String> edit(@RequestBody TaskEditRequest request){
        taskTools.refreshCron(request.getId(),request.getCron());
        return R.<String>builder().success().message("更新成功").build();
    }

    @PostMapping("/run/{id}")
    public R<String> run(@PathVariable String id){
        taskTools.run(id);
        return R.<String>builder().success().message("执行成功").build();
    }

    @PostMapping("/start/{id}")
    public R<String> start(@PathVariable String id){
        taskTools.start(id);
        return R.<String>builder().success().message("执行成功").build();
    }

}
