/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.data.YueCpuInfo;
import cn.xisoil.data.YueDiskInfo;
import cn.xisoil.data.YueMemoryInfo;
import cn.xisoil.data.YueServerInfo;
import cn.xisoil.data.properties.YueProperties;
import cn.xisoil.data.result.R;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;

@RestController
@RequestMapping(value={"/manage/system"})
public class CpuInfoController
implements PermissionCheckAutomation {
    @Autowired
    private YueProperties yueProperties;

    @GetMapping(value={"/cpu"})
    public R<YueCpuInfo> getCpu() throws InterruptedException {
        SystemInfo systemInfo = new SystemInfo();
        CentralProcessor processor = systemInfo.getHardware().getProcessor();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Thread.sleep(500L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
        YueCpuInfo yueCpuInfo = new YueCpuInfo();
        yueCpuInfo.setCpuCount(processor.getLogicalProcessorCount());
        yueCpuInfo.setUtilization(new DecimalFormat("#.##%").format((double)cSys * 1.0 / (double)totalCpu));
        yueCpuInfo.setUserUtilization(new DecimalFormat("#.##%").format((double)user * 1.0 / (double)totalCpu));
        yueCpuInfo.setIdleness(new DecimalFormat("#.##%").format((double)idle * 1.0 / (double)totalCpu));
        return R.builder().success().data((Object)yueCpuInfo).build();
    }

    @GetMapping(value={"/memory"})
    public R<YueMemoryInfo> getMemory() {
        SystemInfo systemInfo = new SystemInfo();
        GlobalMemory memory = systemInfo.getHardware().getMemory();
        long totalByte = memory.getTotal();
        long acaliableByte = memory.getAvailable();
        YueMemoryInfo yueMemoryInfo = new YueMemoryInfo();
        yueMemoryInfo.setMemorySize(CpuInfoController.formatByte(totalByte));
        yueMemoryInfo.setMemoryUsage(new DecimalFormat("#.##%").format((double)(totalByte - acaliableByte - memory.getVirtualMemory().getSwapUsed()) * 1.0 / (double)totalByte));
        yueMemoryInfo.setMemoryFree(CpuInfoController.formatByte(acaliableByte));
        yueMemoryInfo.setMemoryUse(CpuInfoController.formatByte(totalByte - acaliableByte));
        MemoryUsage mxb = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        yueMemoryInfo.setJvmMemorySize(CpuInfoController.formatByte(mxb.getMax()));
        yueMemoryInfo.setJvmMemoryFree(CpuInfoController.formatByte(mxb.getMax() - mxb.getCommitted() - mxb.getUsed()));
        yueMemoryInfo.setJvmMemoryUse(CpuInfoController.formatByte(mxb.getCommitted() + mxb.getUsed()));
        yueMemoryInfo.setJvmMemoryUsage(new DecimalFormat("#.##%").format((double)(mxb.getCommitted() + mxb.getUsed()) * 1.0 / (double)mxb.getMax()));
        return R.builder().success().data((Object)yueMemoryInfo).build();
    }

    @GetMapping(value={"/server"})
    public R<YueServerInfo> getServer() throws UnknownHostException {
        YueServerInfo yueServerInfo = new YueServerInfo();
        Properties props = System.getProperties();
        InetAddress addr = InetAddress.getLocalHost();
        System.out.println(addr.getHostAddress());
        System.out.println(addr.getCanonicalHostName());
        System.out.println(addr.getHostName());
        System.out.println(addr.getAddress());
        yueServerInfo.setServerIp(addr.getHostAddress());
        Map<String, String> map = System.getenv();
        yueServerInfo.setServerName(map.get("COMPUTERNAME"));
        yueServerInfo.setEquipment(props.getProperty("os.name"));
        yueServerInfo.setArchitecture(props.getProperty("os.arch"));
        yueServerInfo.setJavaServerName(props.getProperty("java.vm.name"));
        yueServerInfo.setJavaVersion(props.getProperty("java.version"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        yueServerInfo.setStartTime(simpleDateFormat.format(this.yueProperties.getStartTime()));
        yueServerInfo.setRunTime(this.yueProperties.getRunTime());
        yueServerInfo.setJavaDir(props.getProperty("java.home"));
        yueServerInfo.setProjectDir(props.getProperty("user.dir"));
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        yueServerInfo.setRunParameters(bean.getInputArguments().toString());
        return R.builder().success().data((Object)yueServerInfo).build();
    }

    @GetMapping(value={"/disk"})
    public R<List<YueDiskInfo>> getDisk() throws UnknownHostException {
        ArrayList<YueDiskInfo> yueDiskInfos = new ArrayList<YueDiskInfo>();
        SystemInfo si = new SystemInfo();
        FileSystem fileSystem = si.getOperatingSystem().getFileSystem();
        List fsArray = fileSystem.getFileStores();
        for (OSFileStore fs : fsArray) {
            long free = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            long used = total - free;
            YueDiskInfo sysFile = new YueDiskInfo();
            sysFile.setDirName(fs.getMount());
            sysFile.setSysTypeName(fs.getType());
            sysFile.setTypeName(fs.getName());
            sysFile.setTotal(CpuInfoController.formatByte(total));
            sysFile.setFree(CpuInfoController.formatByte(free));
            sysFile.setUsed(CpuInfoController.formatByte(used));
            sysFile.setUsage(new DecimalFormat("#.##%").format((double)used * 1.0 / (double)total));
            yueDiskInfos.add(sysFile);
        }
        return R.builder().success().data(yueDiskInfos).build();
    }

    public static String formatByte(long byteNumber) {
        double FORMAT = 1024.0;
        double kbNumber = (double)byteNumber / FORMAT;
        if (kbNumber < FORMAT) {
            return new DecimalFormat("#.##KB").format(kbNumber);
        }
        double mbNumber = kbNumber / FORMAT;
        if (mbNumber < FORMAT) {
            return new DecimalFormat("#.##MB").format(mbNumber);
        }
        double gbNumber = mbNumber / FORMAT;
        if (gbNumber < FORMAT) {
            return new DecimalFormat("#.##GB").format(gbNumber);
        }
        double tbNumber = gbNumber / FORMAT;
        return new DecimalFormat("#.##TB").format(tbNumber);
    }

    public String getUrl() {
        return "/system/server";
    }

    public String getName() {
        return "\u670d\u52a1\u76d1\u63a7";
    }

    public String getParent() {
        return "\u7cfb\u7edf\u7ba1\u7406";
    }

    public boolean auto() {
        return true;
    }
}

