package cn.xisoil.service.impl;


import cn.xisoil.service.TableDDLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.stereotype.Service;

//import javax.annotation.Resource;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;


@Service
public  class TableDDLServiceImpl implements TableDDLService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean;
    @Autowired
    private HibernateProperties hibernateProperties;
    @Autowired
    private JpaProperties jpaProperties;


    //初始化表结构
    @Override
    public void updateTable() {
        Map<String, Object> properties = hibernateProperties.determineHibernateProperties(jpaProperties.getProperties(), new HibernateSettings());
        localContainerEntityManagerFactoryBean.setJpaPropertyMap(properties);
        localContainerEntityManagerFactoryBean.afterPropertiesSet();
    }

    @Override
    public void initDBData(DataSource dataSource, List<String> sqls) {
        try{
            Connection connection= dataSource.getConnection();
            sqls.forEach(sql->{
                try {
                    connection.createStatement().execute(sql);
                } catch (SQLException throwables) {
                    System.out.println(throwables.getMessage());
                }
            });
        }
        catch (Exception e){
            logger.warn("数据库初始化失败===>"+e.getMessage());
        }

    }


}