package cn.xisoil.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * 注册数据源配置
 */
@Configuration
@EnableJpaRepositories(basePackages = {"com.vt.*"}
        ,transactionManagerRef ="platformTransactionManager",entityManagerFactoryRef = "entityManagerFactory")
public class DynamicDataSourceConfig {

    @Autowired
    private DynamicDataSource dynamicDataSource;

    @Primary
    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder){
        return builder.dataSource(dynamicDataSource).packages("com.vt.*").build();
    }

    @Bean
    public PlatformTransactionManager platformTransactionManager(EntityManagerFactoryBuilder builder){
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean=entityManagerFactory(builder);
        return new JpaTransactionManager(localContainerEntityManagerFactoryBean.getObject());
    }





}