/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.impl;

import cn.xisoil.service.TableDDLService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.stereotype.Service;

@Service
public class TableDDLServiceImpl
implements TableDDLService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean;
    @Autowired
    private HibernateProperties hibernateProperties;
    @Autowired
    private JpaProperties jpaProperties;

    @Override
    public void updateTable() {
        Map properties = this.hibernateProperties.determineHibernateProperties(this.jpaProperties.getProperties(), new HibernateSettings());
        this.localContainerEntityManagerFactoryBean.setJpaPropertyMap(properties);
        this.localContainerEntityManagerFactoryBean.afterPropertiesSet();
    }

    @Override
    public void initDBData(DataSource dataSource, List<String> sqls) {
        try {
            Connection connection = dataSource.getConnection();
            sqls.forEach(sql -> {
                try {
                    connection.createStatement().execute((String)sql);
                }
                catch (SQLException throwables) {
                    System.out.println(throwables.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("\u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25===>" + e.getMessage());
        }
    }
}

