/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service;

import cn.xisoil.config.DynamicDataSource;
import cn.xisoil.config.LocalDataSource;
import cn.xisoil.data.DataSourceConfiguration;
import cn.xisoil.exception.RegisterException;
import cn.xisoil.holder.DataSourceHolder;
import cn.xisoil.service.TableDDLService;
import cn.xisoil.utils.SpringContextUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSourceRegistrationComponent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private DynamicDataSource dynamicDataSource;
    @Autowired
    private LocalDataSource localDataSource;
    @Autowired
    private TableDDLService tableDDLService;

    public HikariDataSource registerDataSource(DataSourceConfiguration dataSourceConfiguration) {
        if (this.springContextUtils.containsBean(dataSourceConfiguration.getKey())) {
            this.logger.error("register error=====>\u6570\u636e\u6e90\u5df2\u5b58\u5728");
            throw new RegisterException("\u6570\u636e\u6e90\u5df2\u5b58\u5728");
        }
        HikariConfig config = new HikariConfig();
        BeanUtils.copyProperties((Object)dataSourceConfiguration, (Object)config);
        HikariDataSource hikariDataSource = new HikariDataSource(config);
        this.springContextUtils.registerSingleton(dataSourceConfiguration.getKey(), (Object)hikariDataSource);
        this.localDataSource.setDataSourceMap(dataSourceConfiguration.getKey(), hikariDataSource);
        if (dataSourceConfiguration.getDefault().booleanValue()) {
            this.localDataSource.defaultTableBase(dataSourceConfiguration.getKey());
        }
        this.logger.info(String.format("register success=====>\u6570\u636e\u6e90: %s\u6ce8\u518c\u6210\u529f", dataSourceConfiguration.getKey()));
        this.refreshJpaDataSource();
        DataSourceHolder.setDataSource(dataSourceConfiguration.getKey());
        this.tableDDLService.updateTable();
        return hikariDataSource;
    }

    public void initDBData(DataSource dataSource, List<String> sqls) {
        this.tableDDLService.initDBData(dataSource, sqls);
    }

    public void removeDataSource(String key) {
        if (!this.springContextUtils.containsBean(key)) {
            this.logger.warn("remove warn=====>\u5df2\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u4f46\u662f\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        } else {
            HikariDataSource hikariDataSource = (HikariDataSource)this.springContextUtils.getBean(key);
            hikariDataSource.close();
            this.springContextUtils.destroySingleton(key);
            this.localDataSource.delDataSourceMap(key);
            this.logger.info("register success=====>\u6570\u636e\u6e90\u5df2\u79fb\u9664");
            this.refreshJpaDataSource();
        }
    }

    public void clearDataSource() {
        this.logger.warn("remove warn=====>\u6e05\u9664\u6240\u6709\u6570\u636e\u6e90\u5c06\u5bfc\u81f4\u7a0b\u5e8f\u4e0d\u53ef\u7528");
        this.localDataSource.getDataSourceMap().forEach((k, v) -> ((HikariDataSource)v).close());
        this.localDataSource.setDataSourceMap(new HashMap<Object, Object>());
        this.logger.info("register success=====>\u6570\u636e\u6e90\u5df2\u6e05\u7a7a");
        this.refreshJpaDataSource();
    }

    public void updateDataSource(DataSourceConfiguration dataSourceConfiguration) {
        if (!this.springContextUtils.containsBean(dataSourceConfiguration.getKey())) {
            this.logger.error("register error=====>\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
            throw new RegisterException("\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        this.removeDataSource(dataSourceConfiguration.getKey());
        this.registerDataSource(dataSourceConfiguration);
    }

    private void createDDl() {
        Configuration cfg = new Configuration().configure();
    }

    private void refreshJpaDataSource() {
        this.dynamicDataSource.setTargetDataSources(this.localDataSource.getDataSourceMap());
        this.dynamicDataSource.afterPropertiesSet();
    }
}

